////////New Ship Rates:
//7th = 0 to 8
//6th = 9 to 19
//5th = 20 to 29
//4th = 30 to 39
//3rd = 40 to 60
//2nd = 61 to 79
//1st = 80+

void InitShips()
{
  ref refShip;

	for (int idx=0;idx<SHIP_TYPES_QUANTITY_WITH_FORT;idx++)
	{
		makeref(refShip,ShipsTypes[idx]);

		refship.index = idx;

		refship.InertiaAccelerationX = 0.2;		refship.InertiaBrakingX = 0.7;
		refship.InertiaAccelerationY = 0.4;		refship.InertiaBrakingY = 0.4;
		refship.InertiaAccelerationZ = 1.0;		refship.InertiaBrakingZ = 1.0;

		refship.Rocking.y = 0.5;
		refship.Rocking.az = 0.05;

		refship.NetGeraldSails = "";
		refship.Soundtype = "";

		refship.WaterLine = 0.0;
		refship.SpeedDependWeight = 0.0;
		refship.SubSeaDependWeight = 0.0;
		refship.TurnDependWeight = 0.0;
		refship.TurnDependSpeed = 0.0;

		refShip.Height.Bombs.Y		= 3.0;		refShip.Height.Bombs.DY		= 1.0;
		refShip.Height.Grapes.Y		= 4.0;		refShip.Height.Grapes.DY	= 1.0;
		refShip.Height.Knippels.Y	= 25.0;		refShip.Height.Knippels.DY	= 15.0;
		refShip.Height.Balls.Y		= 3.0;		refShip.Height.Balls.DY		= 1.0;

        refship.WindAgainstSpeed   = 1.0;//boal
		refship.CabinType          = "Cabin_Small"; //    My_     
        refShip.AbordageLocation			= "BOARDING_SMALL_DECK";
        refship.DeckType          = "Low";
        
		refShip.MaxCaliber	= 8;
		refShip.Cannon		= CANNON_TYPE_CANNON_LBS4;

		aref cannonl, cannonr, cannonb, cannonf;

		refship.CanEncounter = true;
		refship.Type.Merchant = true;
		refship.Type.War = true;
		refship.Track.Enable = false;
		refShip.FireHeight = 3.0;

		refShip.Massa = 1500000.0;
		refShip.Volume = 900.0;
		refShip.lowpolycrew = 5;
		refShip.buildtime = 10;

		refShip.rcannon = 0;
		refShip.lcannon = 0;
		refShip.fcannon = 0;
		refShip.bcannon = 0;

		makearef(cannonl,ShipsTypes[idx].Cannons.Borts.cannonl);
		makearef(cannonr,ShipsTypes[idx].Cannons.Borts.cannonr);
		makearef(cannonf,ShipsTypes[idx].Cannons.Borts.cannonf);
		makearef(cannonb,ShipsTypes[idx].Cannons.Borts.cannonb);

		cannonf.FireZone	= Degree2Radian(30.0);
		cannonf.FireDir		= Degree2Radian(0.0);
		cannonf.FireAngMin	= -0.35;
		cannonf.FireAngMax	= 0.60;

		cannonr.FireZone	= Degree2Radian(80.0);
		cannonr.FireDir		= Degree2Radian(90.0);
		cannonr.FireAngMin	= -0.35;
		cannonr.FireAngMax	= 0.60;

		cannonb.FireZone	= Degree2Radian(30.0);
		cannonb.FireDir		= Degree2Radian(180.0);
		cannonb.FireAngMin	= -0.35;
		cannonb.FireAngMax	= 0.60;

		cannonl.FireZone	= Degree2Radian(80.0);
		cannonl.FireDir		= Degree2Radian(270.0);
		cannonl.FireAngMin	= -0.35;
		cannonl.FireAngMax	= 0.60;
	}

	///////////////////////////////////////////////////////////////////////////
	//// Boat
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BOAT]);
	refShip.Name				= "Boat";
	refship.Soundtype				= "lugger";
	refShip.Class				= 7;
	refShip.Cannon				= CANNON_TYPE_NONECANNON;
	refShip.MaxCaliber				= 4;
	refShip.Weight				= Tonnes2CWT(10);
	refShip.Capacity				= 50;
	refShip.CannonsQuantity			= 0;
	refShip.rcannon 							= 0;
	refShip.lcannon 							= 0;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew				= 10; //sailing crew
	refShip.MinCrew				= 2;
	refShip.BoardingCrew						= 0;
	refShip.GunnerCrew							= 0;
	refShip.CannonerCrew						= 0;
	refShip.SailorCrew							= 4;
	refShip.SpeedRate							= 4;
	refShip.TurnRate							= 30.0;
	refShip.Price				= 300;
	refShip.HP					= 100;
	refShip.SP					= 200;
	refship.CanEncounter					= false;
	refship.Type.Merchant					= false;
	refship.Type.War						= false;
	refShip.lowpolycrew = 0;

	refship.WaterLine							= -0.3;

	refShip.Massa = 10000.0;
	refShip.Volume = 100.0;
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 3.0;
	refship.InertiaAccelerationY	= 0.4;	refship.InertiaBrakingY		= 0.2;
	refship.InertiaAccelerationZ	= 0.15;	refship.InertiaBrakingZ		= 0.05;


///////////////////////////////////////////////////////////////////////////
//class 7
///////////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////
	//// Tartane
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_TARTANE]);
	refShip.Name				= "Tartane";
	refship.Soundtype				= "lugger";
	refShip.Class				= 7;
	refShip.Cannon				= CANNON_TYPE_NONECANNON;
	refShip.MaxCaliber				= 4;
	refShip.Weight				= Tonnes2CWT(10);
	refShip.Capacity				= 50;
	refShip.CannonsQuantity			= 0;
	refShip.rcannon 							= 0;
	refShip.lcannon 							= 0;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew				= 12;
	refShip.MinCrew				= 2;
	refShip.BoardingCrew						= 8;
	refShip.GunnerCrew							= 0;
	refShip.CannonerCrew						= 0;
	refShip.SailorCrew							= 4;
	refShip.SpeedRate							= 7.0;
	refShip.TurnRate							= 16.0;
	refShip.Price				= 500;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP					= 200;
}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 100;
}
	refShip.SP					= 200;
	refship.CanEncounter					= false;
	refship.Type.Merchant					= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed				= 10.0;
	refShip.sea_enchantment					= 4.0;
	refShip.lowpolycrew = 3;
	refShip.buildtime = 10;

	refShip.Massa = 10000.0;
	refShip.Volume = 20.0;
	refship.WindAgainstSpeed   = 8.0;//boal
	
	refship.InertiaAccelerationX	= 3.0;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 14;	refship.InertiaBrakingY		= 5;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 3.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 9;
	refship.Track1.Width	= "1.0, 2.0";
	refship.Track1.Speed	= "5.2, 6.2";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7;
	refship.Track2.Width	= "1.2, 2.0";
	refship.Track2.Speed	= "0.15, 0.25";

	 //Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	//// War Tartane
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_WAR_TARTANE]);
	refShip.Name			= "WarTartane";
	refship.Soundtype			= "lugger";
	refShip.Class			= 7;
	refShip.Cannon			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber			= 4;
	refShip.Weight			= Tonnes2CWT(10);
	refShip.Capacity			= 210;
	refShip.CannonsQuantity		= 8;
	refShip.rcannon 							= 4;
	refShip.lcannon 							= 4;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew			= 20;
	refShip.MinCrew			= 3;
	refShip.BoardingCrew						= 3;
	refShip.GunnerCrew							= 8;
	refShip.CannonerCrew						= 8;
	refShip.SailorCrew							= 30;
	refShip.SpeedRate							= 10.0;
	refShip.TurnRate							= 16.0;
	refShip.Price			= 2500;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP				= 350;
}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 250;
}
	refShip.SP				= 200;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.CanEncounter					= true;
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 10.5;
	refShip.sea_enchantment					= 3.0;
	refShip.lowpolycrew						= 3;
	refShip.buildtime = 10;
	
	refShip.Massa = 50000.0;
	refShip.Volume = 100.0;

	refship.WaterLine					= -0.1;
	refship.SpeedDependWeight			= 0.2;
	refship.SubSeaDependWeight			= 0.4;
	refship.TurnDependWeight			= 0.2;
    	refship.WindAgainstSpeed   = 7.0;//boal
    
	refship.InertiaAccelerationX	= 3.0;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 14;	refship.InertiaBrakingY		= 5;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 3.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 9;
	refship.Track1.Width	= "1.0, 2.0";
	refship.Track1.Speed	= "5.2, 6.2";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7;
	refship.Track2.Width	= "1.2, 2.0";
	refship.Track2.Speed	= "0.15, 0.25";

	 //Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	//// Lugger
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_LUGGER]);
	refShip.Name            			= "Lugger";
	refship.Soundtype			= "lugger";
	refShip.Class			= 7;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(150);
	refShip.Capacity        			= 800;
	refShip.CannonsQuantity				= 8;
	refShip.rcannon 				= 4;
	refShip.lcannon 				= 4;
	refShip.fcannon 				= 0;
	refShip.bcannon 				= 0;
	refShip.MaxCrew         		= 46;
	refShip.MinCrew         			= 5;
	refShip.BoardingCrew				= 17;
	refShip.GunnerCrew					= 8;
	refShip.CannonerCrew				= 16;
	refShip.SailorCrew					= 56;
	refShip.SpeedRate       			= 15.5;
	refShip.TurnRate        			= 15.0;
	refShip.Price           			= 12000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 2600;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 1600;
}
	refShip.SP              			= 200;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 6.7;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 8;
	refShip.buildtime = 20;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine		= -0.5;
	refship.SpeedDependWeight	= 0.2;
	refship.SubSeaDependWeight	= 0.6;
	refship.TurnDependWeight	= 0.2;
	refship.WindAgainstSpeed   	= 10.0;//boal
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 2.0;
	
	refShip.Height.Bombs.Y		= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y		= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y	= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y		= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.20;
	refship.Track1.LifeTime 	= 9;
	refship.Track1.Width		= "2.0, 3.0";
	refship.Track1.Speed		= "8.0, 10.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 7;
	refship.Track2.Width		= "3.0, 4.5";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	//// bermsloop
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BERMSLOOP]);
	refShip.Name            			= "Bermsloop";
	refship.Soundtype			= "lugger";
	refShip.Class			= 7;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(150);
	refShip.Capacity        			= 740;
	refShip.CannonsQuantity		= 8;
	refShip.rcannon 							= 3;
	refShip.lcannon 							= 3;
	refShip.fcannon 							= 1;
	refShip.bcannon 							= 1;
	refShip.MaxCrew         		= 46;
	refShip.MinCrew         			= 4;
	refShip.BoardingCrew				= 18;
	refShip.GunnerCrew					= 8;
	refShip.CannonerCrew				= 16;
	refShip.SailorCrew					= 56;
	refShip.SpeedRate       			= 12.2;
	refShip.TurnRate        			= 16.0;
	refShip.Price           			= 7000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 2500;
}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 1500;
}
	refShip.SP              			= 200;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed				= 8.0;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 8;
	refShip.buildtime = 20;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= -0.0;
	refship.SpeedDependWeight			= 0.4;
	refship.SubSeaDependWeight			= 0.5;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 8.0;//boal

	refship.InertiaAccelerationX	= 1.0;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 15;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 3.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 9;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "8.0, 10.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7;
	refship.Track2.Width	= "3.0, 4.5";
	refship.Track2.Speed	= "0.15, 0.25";	

	 //Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	/////////////////////////////////////////////////////////////////////////
	//// Schooner - Hannah
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_HANNAH]);
	refShip.Name            				= "Hannah";
	refship.Soundtype				= "lugger";
	refShip.Class			= 7;
	refShip.Cannon          					= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      	= 8;
	refShip.Weight							= Tonnes2CWT(150);
	refShip.Capacity        			= 950;
	refShip.CannonsQuantity					= 4;
	refShip.rcannon 									= 2;
	refShip.lcannon 									= 2;
	refShip.fcannon 									= 0;
	refShip.bcannon 									= 0;
	refShip.MaxCrew         			= 42;
	refShip.MinCrew         				= 6;
	refShip.BoardingCrew				= 24;
	refShip.GunnerCrew						= 4;
	refShip.CannonerCrew					= 8;
	refShip.SailorCrew				= 52;
	refShip.SpeedRate					= 11.8;
	refShip.TurnRate        			= 15.0;
	refShip.Price           		= 15000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              	= 2800;
}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 1800;
}
	refShip.SP              	= 200;
	refShip.AbordageLocation				= "Boarding Deck_02";
	refship.Type.Merchant						= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed	= 8.0;
	refShip.sea_enchantment		= 2.0;
	refShip.lowpolycrew 					= 10;
	refShip.buildtime 					= 40;

	refship.Rocking.y 		= 0.4;
	refship.Rocking.az 		= 0.03;

	refship.WaterLine		= 0.2;

	refship.SpeedDependWeight	= 0.2;
	refship.SubSeaDependWeight	= 0.2;
	refship.TurnDependWeight	= 0.3;
	refship.WindAgainstSpeed   	= 7.5;//boal
	
	refship.InertiaAccelerationX	= 8.0;	refship.InertiaBrakingX		= 8.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 6.0;
	
	refShip.Height.Bombs.Y		= 1.0;	refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y		= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y	= 15.0;	refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y		= 1.0;	refShip.Height.Balls.DY		= 1.0;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.20;
	refship.Track1.LifeTime 	= 8;
	refship.Track1.Width		= "1.2, 2.2";
	refship.Track1.Speed		= "7.2, 8.2";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 6;
	refship.Track2.Width		= "2.2, 3.2";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	//// Ketch - Nonsuch
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_KETCH]);
	refShip.Name            				= "Ketch";
	refship.Soundtype				= "lugger";
	refShip.Class			= 7;
	refShip.Cannon          					= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      	= 8;
	refShip.Weight							= Tonnes2CWT(150);
	refShip.Capacity        			= 850;
	refShip.CannonsQuantity					= 8;
	refShip.rcannon 									= 4;
	refShip.lcannon 									= 4;
	refShip.fcannon 									= 0;
	refShip.bcannon 									= 0;
	refShip.MaxCrew         		= 46;
	refShip.MinCrew         				= 5;
	refShip.BoardingCrew			= 17;
	refShip.GunnerCrew					= 8;
	refShip.CannonerCrew			= 16;
	refShip.SailorCrew					= 56;
	refShip.SpeedRate       			= 11.7;
	refShip.TurnRate        				= 14.0;
	refShip.Price           		= 8000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              	= 2950;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 1950;
}
	refShip.SP              	= 200;
	refShip.AbordageLocation	= "Boarding Deck_02";
	refship.Type.Merchant		= true;
	refship.Type.War		= false;
	refShip.fWindAgainstSpeed	= 7.0;
	refShip.sea_enchantment		= 2.0;
	refShip.lowpolycrew 		= 8;
	refShip.buildtime 		= 20;

	refship.Rocking.y 		= 0.5;
	refship.Rocking.az 		= 0.035;
	
	refship.WaterLine		= 0.0;
	refship.SpeedDependWeight	= 0.2;
	refship.SubSeaDependWeight	= 0.6;
	refship.TurnDependWeight	= 0.2;
	refship.WindAgainstSpeed   	= 10.0;//boal
	
	refship.InertiaAccelerationX	= 10.0;	refship.InertiaBrakingX		= 10.0;
	refship.InertiaAccelerationY	= 10;	refship.InertiaBrakingY		= 10;
	refship.InertiaAccelerationZ	= 10.0;	refship.InertiaBrakingZ		= 10.0;
	
	refShip.Height.Bombs.Y		= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y		= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y	= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y		= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.20;
	refship.Track1.LifeTime 	= 9;
	refship.Track1.Width		= "2.0, 3.0";
	refship.Track1.Speed		= "8.0, 10.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 7;
	refship.Track2.Width		= "3.0, 4.5";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Bounty
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BOUNTY]);
	refShip.Name            			= "Bounty";
	refship.Soundtype			= "lugger";
	refShip.Class			= 7;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(200);
	refShip.Capacity        			= 1450;
	refShip.CannonsQuantity		= 4;
	refShip.rcannon 							= 2;
	refShip.lcannon 							= 2;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew         			= 46;
	refShip.MinCrew         			= 8;
	refShip.BoardingCrew						= 26;
	refShip.GunnerCrew							= 4;
	refShip.CannonerCrew				= 8;
	refShip.SailorCrew					= 56;
	refShip.SpeedRate       			= 10.5;
	refShip.TurnRate        			= 18.0;
	refShip.Price           			= 22000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3400;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2400;
}
	refShip.SP              			= 200;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 2;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.01;
	refship.SpeedDependWeight			= 0.27;
	refship.SubSeaDependWeight			= 0.6;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.3;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Empress - Empress
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_EMPRESS]);
	refShip.Name            			= "Empress";
	refship.Soundtype			= "lugger";
	refShip.Class			= 7;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(200);
	refShip.Capacity       			= 3400;
	refShip.CannonsQuantity		= 10;
	refShip.rcannon 							= 5;
	refShip.lcannon 							= 5;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew         		= 76;
	refShip.MinCrew         		= 8;
	refShip.BoardingCrew				= 38;
	refShip.GunnerCrew				= 10;
	refShip.CannonerCrew				= 20;
	refShip.SailorCrew				= 86;
	refShip.SpeedRate				= 10.7;
	refShip.TurnRate        			= 7.0;
	refShip.Price           			= 34000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3600;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2600;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant				= true;
	refship.Type.War				= false;
	refShip.fWindAgainstSpeed			= 1.0;
	refShip.sea_enchantment				= 1.8;
	refShip.lowpolycrew 				= 10;
	refShip.buildtime 				= 40;

	refship.Rocking.y 				= 0.4;
	refship.Rocking.az 				= 0.025;
	
	refship.WaterLine				= 0.04;
	refship.SpeedDependWeight			= 0.15;
	refship.SubSeaDependWeight			= 0.8;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   			= 3.6;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 4.0;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;

	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable				= true;
	refship.Track1.ZStart				= 0.20;
	refship.Track1.LifeTime 			= 7.5;
	refship.Track1.Width				= "6.0, 7.0";
	refship.Track1.Speed				= "7.2, 9.2";

	refship.Track2.ZStart				= -0.15;
	refship.Track2.LifeTime 			= 5.0;
	refship.Track2.Width				= "6.0, 8.0";
	refship.Track2.Speed				= "0.15, 0.25";

	 //Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	//// Lyon Hoy 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_LYON]);
	refShip.Name            			= "Lyon";
	refship.Soundtype					= "lugger";
	refShip.Class					= 7;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight						= Tonnes2CWT(170);
	refShip.Capacity        			= 1000;
	refShip.CannonsQuantity				= 8;
	refShip.rcannon 					= 4;
	refShip.lcannon 					= 4;
	refShip.fcannon 					= 0;
	refShip.bcannon 					= 0;
	refShip.MaxCrew         			= 52;
	refShip.MinCrew         			= 5;
	refShip.BoardingCrew				= 23;
	refShip.GunnerCrew					= 8;
	refShip.CannonerCrew				= 16;
	refShip.SailorCrew					= 62;
	refShip.SpeedRate					= 11.8;
	refShip.TurnRate        			= 11.0;
	refShip.Price           			= 20000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3200;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2200;
}
	refShip.SP              			= 200;
	//refShip.AbordageLocation			= "Boarding Deck_02";
	refship.CanEncounter					= true;
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 8.5;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 8;
	refShip.buildtime = 20;
	
	refship.Rocking.y = 0.45;
	refship.Rocking.az = 0.02;
	
	refship.WaterLine							= -0.0;

	refship.SpeedDependWeight			= 0.2;
	refship.SubSeaDependWeight			= 0.3;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 8.0;//boal
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 10;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.0;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 9;
	refship.Track1.Width	= "2.0, 2.5";
	refship.Track1.Speed	= "5.2, 6.2";

	refship.Track2.ZStart	= -0.05;
	refship.Track2.LifeTime = 7;
	refship.Track2.Width	= "3.0, 4.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //


///////////////////////////////////////////////////////////////////////////
//class 6
///////////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////
	//// Sloop 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SLOOP]);
	refShip.Name            			= "Sloop";
	refship.Soundtype			= "lugger";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(170);
	refShip.Capacity        			= 1050;
	refShip.CannonsQuantity				= 14;
	refShip.rcannon 				= 6;
	refShip.lcannon 				= 6;
	refShip.fcannon 				= 0;
	refShip.bcannon 				= 2;
	refShip.MaxCrew         			= 70;
	refShip.MinCrew         			= 7;
	refShip.BoardingCrew				= 21;
	refShip.GunnerCrew					= 14;
	refShip.CannonerCrew				= 28;
	refShip.SailorCrew					= 80;
	refShip.SpeedRate					= 12.8;
	refShip.TurnRate        			= 16.0;
	refShip.Price           			= 18000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3100;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2100;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 7;
	refShip.sea_enchantment					= 3.0;
	refShip.lowpolycrew = 8;
	refShip.buildtime = 20;
	
	refship.Rocking.y 		= 0.45;
	refship.Rocking.az 		= 0.02;
	
	refship.WaterLine		= 0.0;

	refship.SpeedDependWeight	= 0.2;
	refship.SubSeaDependWeight	= 0.3;
	refship.TurnDependWeight	= 0.3;
	refship.WindAgainstSpeed   	= 8.0;//boal
	
	refship.InertiaAccelerationX	= 8.0;	refship.InertiaBrakingX		= 8.0;
	refship.InertiaAccelerationY	= 8;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 8.0;	refship.InertiaBrakingZ		= 8.0;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.20;
	refship.Track1.LifeTime 	= 9;
	refship.Track1.Width		= "2.0, 2.5";
	refship.Track1.Speed		= "5.2, 6.2";

	refship.Track2.ZStart		= -0.05;
	refship.Track2.LifeTime 	= 7;
	refship.Track2.Width		= "3.0, 4.0";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Barque
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BARQUE]);
	refShip.Name            			= "Barque";
	refship.Soundtype			= "lugger";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(350);
	refShip.Capacity       			= 1900;
	refShip.CannonsQuantity		= 16;
	refShip.rcannon 							= 6;
	refShip.lcannon 							= 6;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         		= 75;
	refShip.MinCrew         			= 8;
	refShip.BoardingCrew						= 19;
	refShip.GunnerCrew							= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 85;
	refShip.SpeedRate					= 9.0;
	refShip.TurnRate        			= 9.0;
	refShip.Price           			= 26000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2800;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 1.8;
	refShip.lowpolycrew = 10;
	refShip.buildtime = 40;

	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.025;
	
	refship.WaterLine							= 0.5;
	refship.SpeedDependWeight			= 0.15;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 3.6;//boal
	
	refship.InertiaAccelerationX	= 1.0;	refship.InertiaBrakingX		= 1.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 2.0;	refship.InertiaBrakingZ		= 2.0;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 7.5;
	refship.Track1.Width	= "6.0, 7.0";
	refship.Track1.Speed	= "7.2, 9.2";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 5.0;
	refship.Track2.Width	= "6.0, 8.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Barkentine
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BARKENTINE]);
	refShip.Name            			= "Barkentine";
	refship.Soundtype			= "lugger";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(350);
	refShip.Capacity       			= 2400;
	refShip.CannonsQuantity		= 16;
	refShip.rcannon 							= 6;
	refShip.lcannon 							= 6;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 85;
	refShip.MinCrew         			= 12;
	refShip.BoardingCrew						= 25;
	refShip.GunnerCrew							= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 95;
	refShip.SpeedRate       			= 10.4;
	refShip.TurnRate        			= 13.0;
	refShip.Price           			= 38000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 4550;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3550;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 1.8;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.4;
	refship.SpeedDependWeight			= 0.27;
	refship.SubSeaDependWeight			= 1.4;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 8.5;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";	

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Brigantine
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BRIGANTINE]);
	refShip.Name            			= "Brigantine";
	refship.Soundtype			= "corvette";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(350);
	refShip.Capacity        			= 1600;
	refShip.CannonsQuantity				= 16;
	refShip.rcannon 							= 6;
	refShip.lcannon 							= 6;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 81;
	refShip.MinCrew         			= 12;
	refShip.BoardingCrew						= 21;
	refShip.GunnerCrew							= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 91;
	refShip.SpeedRate       			= 12.5;
	refShip.TurnRate        			= 11.0;
	refShip.Price           			= 27000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 4700;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3700;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 1.8;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.0;
	refship.SpeedDependWeight			= 0.27;
	refship.SubSeaDependWeight			= 0.16;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 9.1;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //
    
	///////////////////////////////////////////////////////////////////////////
	/// Fleut 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_FLEUT]);
	refShip.Name            			= "Fleut";
	refship.Soundtype			= "corvette";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(450);
	refShip.Capacity        			= 3200;
	refShip.CannonsQuantity		= 18;
	refShip.rcannon 							= 7;
	refShip.lcannon 							= 7;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 140;
	refShip.MinCrew         			= 13;
	refShip.BoardingCrew						= 73;
	refShip.GunnerCrew							= 18;
	refShip.CannonerCrew				= 36;
	refShip.SailorCrew					= 180;
	refShip.SpeedRate					= 9.0;
	refShip.TurnRate        			= 6.0;
	refShip.Price           			= 50000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 9300;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 8300;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed				= 1.0;
	refShip.sea_enchantment					= 1.5;
	refShip.lowpolycrew = 16;
	refShip.buildtime = 60;
	
	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.5;
	refship.SpeedDependWeight			= 0.15;
	refship.SubSeaDependWeight			= 1.3;
	refship.TurnDependWeight			= 0.25;
	refship.WindAgainstSpeed   = 4.0;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	refship.DeckType           = "Medium";
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 7;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 2.0;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "8.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "6.0, 8.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; // 
        refShip.spain = 0.0; //
	
	///////////////////////////////////////////////////////////////////////////
	/// Brig
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BRIG]);
	refShip.Name            			= "Brig";
	refship.Soundtype			= "lugger";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(400);
	refShip.Capacity        			= 2000;
	refShip.CannonsQuantity		= 16;
	refShip.rcannon 							= 6;
	refShip.lcannon 							= 6;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 84;
	refShip.MinCrew         			= 10;
	refShip.BoardingCrew						= 26;
	refShip.GunnerCrew							= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 94;
	refShip.SpeedRate       			= 12.2;
	refShip.TurnRate        			= 17.0;
	refShip.Price           			= 32000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3900;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2950;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 1.8;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.57;
	refship.SpeedDependWeight			= 0.27;
	refship.SubSeaDependWeight			= 0.87;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.3;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Pinnace
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_PINNACE]);
	refShip.Name            			= "Pinnace";
	refship.Soundtype			= "frigate";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(800);
	refShip.Capacity        			= 4200;
	refShip.CannonsQuantity		= 16;
	refShip.rcannon 							= 6;
	refShip.lcannon 							= 6;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew				= 189;
	refShip.MinCrew         			= 17;
	refShip.BoardingCrew				= 124;
	refShip.GunnerCrew							= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 240;
	refShip.SpeedRate					= 11.0;
	refShip.TurnRate        			= 8.0;
	refShip.Price           			= 75000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 10950;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 9950;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed				= 1.5;
	refShip.sea_enchantment					= 1.1;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 80;

	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;

	refship.WaterLine							= 0.62;
	refship.SpeedDependWeight			= 0.2;
	refship.SubSeaDependWeight			= 0.82;
	refship.TurnDependWeight			= 0.25;
	refship.WindAgainstSpeed   = 6.0;//boal
    	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
    	refship.DeckType           = "Medium";
    
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 7;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.0;

	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.85;
	refShip.GeraldSails.rey_b2.vscale		= 0.65;
	refShip.GeraldSails.rey_b3.vscale		= 0.65;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.30;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "5.7, 7.9";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "10.0, 12.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	//// Lugger_h
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_LUGGER_H]);
	refShip.Name            			= "Lugger_h";
	refship.Soundtype			= "lugger";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(200);
	refShip.Capacity        			= 990;
	refShip.CannonsQuantity		= 12;
	refShip.rcannon 							= 4;
	refShip.lcannon 							= 4;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         		= 67;
	refShip.MinCrew         			= 7;
	refShip.BoardingCrew				= 24;
	refShip.GunnerCrew					= 12;
	refShip.CannonerCrew				= 24;
	refShip.SailorCrew					= 77;
	refShip.SpeedRate       			= 12.1;
	refShip.TurnRate        			= 15.0;
	refShip.Price           			= 9100;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3250;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2250;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 7.0;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 10;
	refShip.buildtime = 20;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	refship.WaterLine							= 0.50;
	refship.SpeedDependWeight			= 0.4;
	refship.SubSeaDependWeight			= 0.4;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 10.0;//boal

	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 2.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 9;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "8.0, 10.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7;
	refship.Track2.Width	= "3.0, 4.5";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

        ///////////////////////////////////////////////////////////////////////////
	//// Galeoth_h
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_GALEOTH_H]);
	refShip.Name            			= "Galeoth_h";
	refship.Soundtype			= "lugger";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(150);
	refShip.Capacity        			= 850;
	refShip.CannonsQuantity		= 16;
	refShip.rcannon 							= 6;
	refShip.lcannon 							= 6;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         		= 70;
	refShip.MinCrew         			= 8;
	refShip.BoardingCrew				= 14;
	refShip.GunnerCrew					= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 80;
	refShip.SpeedRate       			= 12.8;
	refShip.TurnRate        			= 17.0;
	refShip.Price           			= 11000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3930;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2930;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 6.0;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 8;
	refShip.buildtime = 20;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= -0.0;
	refship.SpeedDependWeight			= 0.2;
	refship.SubSeaDependWeight			= 0.6;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 8.0;//boal

	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 9;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 3.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 9;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "8.0, 10.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7;
	refship.Track2.Width	= "3.0, 4.5";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	//// Yacht
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_YACHT]);
	refShip.Name            			= "Yacht";
	refship.Soundtype			= "lugger";
	refShip.Class			= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(200);
	refShip.Capacity        			= 980;
	refShip.CannonsQuantity		= 16;
	refShip.rcannon 							= 6;
	refShip.lcannon 							= 6;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         		= 68;
	refShip.MinCrew         			= 7;
	refShip.BoardingCrew				= 13;
	refShip.GunnerCrew					= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 78;
	refShip.SpeedRate       			= 11.6;
	refShip.TurnRate        			= 18.0;
	refShip.Price           			= 17000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3500;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2500;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 6.0;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 10;
	refShip.buildtime = 20;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= -0.3;
	refship.SpeedDependWeight			= 0.4;
	refship.SubSeaDependWeight			= 0.6;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 8.0;//boal

	refship.InertiaAccelerationX	= 2.0;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 8;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 2.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 9;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "8.0, 10.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7;
	refship.Track2.Width	= "3.0, 4.5";
	refship.Track2.Speed	= "0.15, 0.25";	

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Brig - Merchant Brig
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SPEEDY]);
	refShip.Name            				= "Speedy";
	refship.Soundtype			= "lugger";
	refShip.Class						= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      		= 12;
	refShip.Weight						= Tonnes2CWT(250);
	refShip.Capacity        			= 2200;
	refShip.CannonsQuantity							= 14;
	refShip.rcannon 							= 7;
	refShip.lcannon 							= 7;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew         			= 79;
	refShip.MinCrew         			= 8;
	refShip.BoardingCrew				= 29;
	refShip.GunnerCrew					= 14;
	refShip.CannonerCrew				= 28;
	refShip.SailorCrew					= 89;
	refShip.SpeedRate       			= 12.5;
	refShip.TurnRate        			= 18.0;
	refShip.Price           			= 27000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3900;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2900;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation				= "Boarding Deck_02";
	refship.Type.Merchant		= true;
	refship.Type.War		= true;
	refShip.fWindAgainstSpeed	= 4.0;
	refShip.sea_enchantment		= 1.8;
	refShip.lowpolycrew 		= 16;
	refShip.buildtime 		= 60;

	refship.Rocking.y 		= 0.5;
	refship.Rocking.az 		= 0.04;
	
	refship.WaterLine		= 0.1;
	refship.SpeedDependWeight	= 0.27;
	refship.SubSeaDependWeight	= 0.6;
	refship.TurnDependWeight	= 0.3;
	refship.WindAgainstSpeed   	= 3.3;//boal
	refship.CabinType          	= "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 5.5;	refship.InertiaBrakingX		= 5.5;
	refship.InertiaAccelerationY	= 8;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 6.0;
	
	refShip.Height.Bombs.Y		= 1.0;	refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y		= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y	= 15.0;	refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y		= 1.0;	refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale	= 0.8;
	refShip.GeraldSails.rey_b3.vscale	= 0.8;
	
	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.20;
	refship.Track1.LifeTime 	= 12;
	refship.Track1.Width		= "2.0, 3.0";
	refship.Track1.Speed		= "6.0, 8.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 7.5;
	refship.Track2.Width		= "4.0, 6.0";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// HMS SOPHIE
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SOPHIE]);
	refShip.Name 			= "Sophie";
	refship.Soundtype 			= "lugger";
	refShip.Class 			= 6;
	refShip.Cannon 			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber 			= 12;
	refShip.Weight 			= Tonnes2CWT(400);
	refShip.Capacity 			= 2400;
	refShip.CannonsQuantity 		= 18;
	refShip.rcannon 							= 9;
	refShip.lcannon 							= 9;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew 				= 90;
	refShip.MinCrew 				= 10;
	refShip.BoardingCrew 					= 46;
	refShip.GunnerCrew 							= 18;
	refShip.CannonerCrew 				= 36;
	refShip.SailorCrew 					= 100;
	refShip.SpeedRate 					= 12.5;
	refShip.TurnRate 				= 14.0;
	refShip.Price 					= 33000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP 					= 4200;
	}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3200;
}
	refShip.SP 					= 250;
	refShip.AbordageLocation 				= "Boarding Deck_02";
	refship.Type.Merchant 					= false;
	refship.Type.War 					= true;
	refShip.fWindAgainstSpeed = 4.0;
	refShip.sea_enchantment = 1.8;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;

	refship.WaterLine = 0.05;
	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 1.3;
	refship.TurnDependWeight = 0.3;
	refship.WindAgainstSpeed = 3.3;//boal
	refship.CabinType = "Cabin_Medium"; // boal 28.03.05

	refship.InertiaAccelerationX = 0.2; refship.InertiaBrakingX = 2.0;
	refship.InertiaAccelerationY = 12; refship.InertiaBrakingY = 9;
	refship.InertiaAccelerationZ = 6.0; refship.InertiaBrakingZ = 4.0;

	refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 1.0;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 15.0; refShip.Height.Knippels.DY = 10.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 1.0;

	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b2.vscale = 0.8;
	refShip.GeraldSails.rey_b3.vscale = 0.8;

	refship.Track.Enable = true;
	refship.Track1.ZStart = 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width = "2.0, 3.0";
	refship.Track1.Speed = "6.0, 8.0";

	refship.Track2.ZStart = -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width = "4.0, 6.0";
	refship.Track2.Speed = "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Interceptor
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_INTERCEPTOR]);
	refShip.Name 			= "Interceptor";
	refship.Soundtype 			= "lugger";
	refShip.Class 			= 6;
	refShip.Cannon 			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber 			= 12;
	refShip.Weight 			= Tonnes2CWT(400);
	refShip.Capacity 			= 2100;
	refShip.CannonsQuantity 		= 18;
	refShip.rcannon 							= 8;
	refShip.lcannon 							= 8;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 2;
	refShip.MaxCrew 				= 95;
	refShip.MinCrew 				= 12;
	refShip.BoardingCrew 					= 29;
	refShip.GunnerCrew 							= 18;
	refShip.CannonerCrew 				= 36;
	refShip.SailorCrew 					= 105;
	refShip.SpeedRate 					= 13.1;
	refShip.TurnRate 				= 14.3;
	refShip.Price 					= 32000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP 					= 4900;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3900;
}
	refShip.SP 					= 250;
	refShip.AbordageLocation 					= "Boarding Deck_02";
	refship.Type.Merchant 					= false;
	refship.Type.War					 = true;
	refShip.fWindAgainstSpeed = 4.0;
	refShip.sea_enchantment = 1.8;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;

	refship.WaterLine = 0.3;
	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 1.3;
	refship.TurnDependWeight = 0.3;
	refship.WindAgainstSpeed = 3.3;//boal
	refship.CabinType = "Cabin_Medium"; // boal 28.03.05

	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;

	refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 1.0;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 15.0; refShip.Height.Knippels.DY = 10.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 1.0;

	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b2.vscale = 0.8;
	refShip.GeraldSails.rey_b3.vscale = 0.8;

	refship.Track.Enable = true;
	refship.Track1.ZStart = 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width = "2.0, 3.0";
	refship.Track1.Speed = "6.0, 8.0";

	refship.Track2.ZStart = -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width = "4.0, 6.0";
	refship.Track2.Speed = "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Castel Friedrichsburg - Brigantine Heavy
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_CASTELF]);
	refShip.Name            			= "Castelf";
	refship.Soundtype					= "corvette";
	refShip.Class						= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight								= Tonnes2CWT(650);
	refShip.Capacity        			= 2700;
	refShip.CannonsQuantity				= 16;
	refShip.rcannon 							= 7;
	refShip.lcannon 							= 7;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 82;
	refShip.MinCrew         			= 14;
	refShip.BoardingCrew						= 20;
	refShip.GunnerCrew							= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 92;
	refShip.SpeedRate       			= 11.5;
	refShip.TurnRate        			= 13.0;
	refShip.Price           			= 31000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 5400;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 4400;
}
	refShip.SP              			= 250;
	//refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 1.8;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.0;
	refship.SpeedDependWeight			= 0.27;
	refship.SubSeaDependWeight			= 0.6;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 6.1;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	refship.DeckType           = "Medium";
	
	refship.InertiaAccelerationX	= 5.5;	refship.InertiaBrakingX		= 5.5;
	refship.InertiaAccelerationY	= 8;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 6.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Fleut - Derfflinger
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_DERFFLINGER]);
	refShip.Name            	= "Derfflinger";
	refship.Soundtype		= "corvette";
	refShip.Class			= 6;
	refShip.Cannon          	= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      	= 16;
	refShip.Weight			= Tonnes2CWT(450);
	refShip.Capacity        	= 3900;
	refShip.CannonsQuantity		= 16;
	refShip.rcannon 		= 8;
	refShip.lcannon 		= 8;
	refShip.fcannon 		= 0;
	refShip.bcannon 		= 0;
	refShip.MaxCrew         	= 180;
	refShip.MinCrew         	= 12;
	refShip.BoardingCrew		= 120;
	refShip.GunnerCrew		= 16;
	refShip.CannonerCrew		= 32;
	refShip.SailorCrew		= 240;
	refShip.SpeedRate		= 10.0;
	refShip.TurnRate        	= 7.8;
	refShip.Price           	= 58000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              	= 10200;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 9200;
}
	refShip.SP              	= 250;
	//refShip.AbordageLocation	= "Boarding Deck_01";
	refship.Type.Merchant		= true;
	refship.Type.War		= false;
	refShip.fWindAgainstSpeed	= 1.2;
	refShip.sea_enchantment		= 1.5;
	refShip.lowpolycrew 		= 16;
	refShip.buildtime 		= 60;
	
	refship.Rocking.y 		= 0.5;
	refship.Rocking.az 		= 0.035;
	
	refship.WaterLine		= -0.6;
	refship.SpeedDependWeight	= 0.15;
	refship.SubSeaDependWeight	= 0.8;
	refship.TurnDependWeight	= 0.25;
	refship.WindAgainstSpeed   	= 4.0;//boal
	refship.CabinType          	= "Cabin_Medium"; // boal 28.03.05
	refship.DeckType           	= "Medium";
	
	refship.InertiaAccelerationX	= 4.5;	refship.InertiaBrakingX		= 4.5;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 4.0;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.20;
	refship.Track1.LifeTime 	= 12;
	refship.Track1.Width		= "2.0, 3.0";
	refship.Track1.Speed		= "8.0, 8.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 7.5;
	refship.Track2.Width		= "6.0, 8.0";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Sloop of war
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_NEPTUNUS]);
	refShip.Name            			= "Neptunus";
	refship.Soundtype					= "corvette";
	refShip.Class					= 6;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight								= Tonnes2CWT(190);
	refShip.Capacity        			= 1600;
	refShip.CannonsQuantity				= 16;
	refShip.rcannon 							= 8;
	refShip.lcannon 							= 8;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew         			= 90;
	refShip.MinCrew         			= 13;
	refShip.BoardingCrew						= 29;
	refShip.GunnerCrew							= 16;
	refShip.CannonerCrew				= 32;
	refShip.SailorCrew					= 100;
	refShip.SpeedRate					= 12.6;
	refShip.TurnRate        			= 14.0;
	refShip.Price           			= 80000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 4200;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3200;
}
	refShip.SP              			= 300;
	//refShip.IsSetupedGerald              		= true;
	//refShip.AbordageLocation			= "Boarding Deck_01";
	refship.CanEncounter					= true;
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.5;
	refShip.sea_enchantment					= 1.5;
	refShip.lowpolycrew = 16;
	refShip.buildtime = 80;

	refship.Rocking.y = 0.8;
	refship.Rocking.az = 0.025;
	
	refship.WaterLine							= -0.6;
	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 0.7;
	refship.TurnDependWeight			= 0.35;
	refship.WindAgainstSpeed   = 2.8;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 8.0;	refship.InertiaBrakingX		= 8.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 6.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.17;
	refship.Track1.LifeTime = 12.5;
	refship.Track1.Width	= "4.0, 5.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 6.5;
	refship.Track2.Width	= "5.0, 7.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //


///////////////////////////////////////////////////////////////////////////
//class 5
///////////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////
	//// Schooner
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SCHOONER]);
	refShip.Name            			= "Schooner";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(200);
	refShip.Capacity        			= 1500;
	refShip.CannonsQuantity		= 20;
	refShip.rcannon 					= 8;
	refShip.lcannon 					= 8;
	refShip.fcannon 					= 2;
	refShip.bcannon 					= 2;
	refShip.MaxCrew         		= 92;
	refShip.MinCrew         			= 7;
	refShip.BoardingCrew				= 25;
	refShip.GunnerCrew					= 20;
	refShip.CannonerCrew				= 40;
	refShip.SailorCrew					= 102;
	refShip.SpeedRate					= 12.0;
	refShip.TurnRate        			= 14.0;
	refShip.Price           			= 26000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3250;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2250;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 8.0;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 40;

	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.03;

	refship.WaterLine					= 0.2;

	refship.SpeedDependWeight			= 0.2;
	refship.SubSeaDependWeight			= 0.6;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 7.5;//boal
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 8;
	refship.Track1.Width	= "1.2, 2.2";
	refship.Track1.Speed	= "7.2, 8.2";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 6;
	refship.Track2.Width	= "2.2, 3.2";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //
		
	///////////////////////////////////////////////////////////////////////////
	/// Galeon LIGHT
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_GALEON_L]);
	refShip.Name            			= "Galeon_l";
	refship.Soundtype					= "corvette";
	refShip.Class					= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(800);
	refShip.Capacity        			= 3600;
	refShip.CannonsQuantity		= 20;
	refShip.rcannon 							= 8;
	refShip.lcannon 							= 8;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 240;
	refShip.MinCrew         			= 19;
	refShip.BoardingCrew						= 161;
	refShip.GunnerCrew							= 20;
	refShip.CannonerCrew				= 40;
	refShip.SailorCrew					= 290;
	refShip.SpeedRate					= 8.0;
	refShip.TurnRate        			= 9.0;
	refShip.Price           			= 60000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 9700;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 8700;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed				= 1.1;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 16;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.45;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.6;
	refship.SpeedDependWeight			= -0.1;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 3.2;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	refship.DeckType           = "Medium";
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 1.0;
	refship.InertiaAccelerationY	= 8;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 16.5;
	refship.Track1.Width	= "5.2, 7.3";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 10.5;
	refship.Track2.Width	= "6.0, 8.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //
	
	///////////////////////////////////////////////////////////////////////////
	/// Dutch - Pinnace
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_DUTCHPINNACE]);
	refShip.Name            	= "DutchPinnace";
	refship.Soundtype		= "frigate";
	refShip.Class			= 5;
	refShip.Cannon          	= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      	= 16;
	refShip.Weight			= Tonnes2CWT(600);
	refShip.Capacity        	= 5400;
	refShip.CannonsQuantity		= 20;
	refShip.rcannon 		= 8;
	refShip.lcannon 		= 8;
	refShip.fcannon 		= 2;
	refShip.bcannon 		= 2;
	refShip.MaxCrew			= 218;
	refShip.MinCrew         	= 20;
	refShip.BoardingCrew		= 138;
	refShip.GunnerCrew		= 20;
	refShip.CannonerCrew		= 40;
	refShip.SailorCrew		= 260;
	refShip.SpeedRate		= 10.6;
	refShip.TurnRate        	= 8.0;
	refShip.Price           	= 95000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              	= 11650;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 10650;
}
	refShip.SP              	= 250;
	refShip.AbordageLocation	= "Boarding Deck_01";
	refship.Type.Merchant		= true;
	refship.Type.War		= false;
	refShip.fWindAgainstSpeed	= 1.1;
	refShip.sea_enchantment		= 1.1;
	refShip.lowpolycrew 		= 20;
	refShip.buildtime 		= 80;

	refship.Rocking.y 		= 0.4;
	refship.Rocking.az 		= 0.035;

	refship.WaterLine		= -0.4;
	refship.SpeedDependWeight	= 0.2;
	refship.SubSeaDependWeight	= 1.3;
	refship.TurnDependWeight	= 0.25;
	refship.WindAgainstSpeed   	= 6.0;//boal
    	refship.CabinType          	= "Cabin_Medium"; // boal 28.03.05
    	refship.DeckType           	= "Medium";
    
	refship.InertiaAccelerationX	= 3.0;	refship.InertiaBrakingX		= 3.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 3.0;	refship.InertiaBrakingZ		= 3.0;

	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale	= 0.85;
	refShip.GeraldSails.rey_b2.vscale	= 0.65;
	refShip.GeraldSails.rey_b3.vscale	= 0.65;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.30;
	refship.Track1.LifeTime 	= 14.5;
	refship.Track1.Width		= "5.7, 7.9";
	refship.Track1.Speed		= "6.0, 8.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 8.5;
	refship.Track2.Width		= "10.0, 12.0";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Pinnace - Fregatte Berlin
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_PINNACEBERLIN]);
	refShip.Name            	= "PinnaceBerlin";
	refship.Soundtype		= "frigate";
	refShip.Class			= 5;
	refShip.Cannon          	= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      	= 16;
	refShip.Weight			= Tonnes2CWT(600);
	refShip.Capacity        	= 2450;
	refShip.CannonsQuantity		= 20;
	refShip.rcannon 		= 8;
	refShip.lcannon 		= 8;
	refShip.fcannon 		= 2;
	refShip.bcannon 		= 2;
	refShip.MaxCrew			= 110;
	refShip.MinCrew         	= 10;
	refShip.BoardingCrew		= 30;
	refShip.GunnerCrew		= 20;
	refShip.CannonerCrew		= 40;
	refShip.SailorCrew		= 180;
	refShip.SpeedRate		= 12.1;
	refShip.TurnRate        	= 8.0;
	refShip.Price           	= 98000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              	= 3850;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2850;
}
	refShip.SP              	= 250;
	refShip.AbordageLocation	= "Boarding Deck_01";
	refship.Type.Merchant		= true;
	refship.Type.War		= true;
	refShip.fWindAgainstSpeed	= 1.3;
	refShip.sea_enchantment		= 1.1;
	refShip.lowpolycrew 		= 28;
	refShip.buildtime 		= 80;

	refship.Rocking.y 		= 0.4;
	refship.Rocking.az 		= 0.035;

	refship.WaterLine		= -0.4;
	refship.SpeedDependWeight	= 0.2;
	refship.SubSeaDependWeight	= 1.3;
	refship.TurnDependWeight	= 0.25;
	refship.WindAgainstSpeed   	= 6.0;//boal
    	refship.CabinType          	= "Cabin_Medium"; // boal 28.03.05
    	refship.DeckType           	= "Medium";
    
	refship.InertiaAccelerationX	= 3.0;	refship.InertiaBrakingX		= 3.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 3.0;	refship.InertiaBrakingZ		= 3.0;

	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale	= 0.85;
	refShip.GeraldSails.rey_b2.vscale	= 0.65;
	refShip.GeraldSails.rey_b3.vscale	= 0.65;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.30;
	refship.Track1.LifeTime 	= 14.5;
	refship.Track1.Width		= "5.7, 7.9";
	refship.Track1.Speed		= "6.0, 8.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 8.5;
	refship.Track2.Width		= "10.0, 12.0";
	refship.Track2.Speed		= "0.15, 0.25";
	
	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// HMS Greyhound
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_GREYHOUND]);
	refShip.Name            			= "Greyhound";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(250);
	refShip.Capacity        			= 2410;
	refShip.CannonsQuantity		= 22;
	refShip.rcannon 							= 10;
	refShip.lcannon 							= 10;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 126;
	refShip.MinCrew         			= 16;
	refShip.BoardingCrew				= 24;
	refShip.GunnerCrew					= 42;
	refShip.CannonerCrew				= 44;
	refShip.SailorCrew					= 136;
	refShip.SpeedRate       			= 12.8;
	refShip.TurnRate        			= 12.0;
	refShip.Price           			= 75000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 5800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 4800;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 3;
	refShip.lowpolycrew = 16;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.2;
	refship.SpeedDependWeight			= 0.37;
	refship.SubSeaDependWeight			= 0.4;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.3;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 9;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// PDN - 24 gun privateer schooner
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_PDN]);
	refShip.Name            			= "PDN";
	refship.Soundtype			= "corvette";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 3200;
	refShip.CannonsQuantity				= 24;
	refShip.rcannon 							= 10;
	refShip.lcannon 							= 10;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 118;
	refShip.MinCrew         			= 18;
	refShip.BoardingCrew						= 28;
	refShip.GunnerCrew							= 24;
	refShip.CannonerCrew				= 48;
	refShip.SailorCrew					= 128;
	refShip.SpeedRate					= 12.4;
	refShip.TurnRate        			= 12.0;
	refShip.Price           			= 110000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 6500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 5500;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.0;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= -1.0;
	refship.SpeedDependWeight			= 0.1;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.8;
	refship.WindAgainstSpeed   = 4.5;//boal
	refship.CabinType          = "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;

        refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 0.5;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 10.0; refShip.Height.Knippels.DY = 8.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 0.5;

	refShip.GeraldSails.rey_b1 = 1;
	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b1.vscale = 0.9;
	refShip.GeraldSails.rey_b2.vscale = 0.7;
	refShip.GeraldSails.rey_b3.vscale = 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// 28GUNFRIGATE - 28 Gun Frigate
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_28GUNFRIGATE]);
	refShip.Name            			= "28GunFrigate";
	refship.Soundtype			= "corvette";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 3200;
	refShip.CannonsQuantity				= 28;
	refShip.rcannon 							= 14;
	refShip.lcannon 							= 14;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew         			= 140;
	refShip.MinCrew         			= 18;
	refShip.BoardingCrew						= 38;
	refShip.GunnerCrew							= 28;
	refShip.CannonerCrew				= 56;
	refShip.SailorCrew					= 150;
	refShip.SpeedRate					= 12.9;
	refShip.TurnRate        			= 15.0;
	refShip.Price           			= 110000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 6500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 5500;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.0;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.2;
	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.8;
	refship.WindAgainstSpeed   = 4.5;//boal
	refship.CabinType          = "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;

        refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 0.5;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 10.0; refShip.Height.Knippels.DY = 8.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 0.5;

	refShip.GeraldSails.rey_b1 = 1;
	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b1.vscale = 0.9;
	refShip.GeraldSails.rey_b2.vscale = 0.7;
	refShip.GeraldSails.rey_b3.vscale = 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// PacketBrig
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_PACKET_BRIG]);
	refShip.Name            			= "Packet_Brig";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(250);
	refShip.Capacity        			= 1800;
	refShip.CannonsQuantity		= 22;
	refShip.rcannon 							= 9;
	refShip.lcannon 							= 9;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 99;
	refShip.MinCrew         			= 14;
	refShip.BoardingCrew				= 19;
	refShip.GunnerCrew					= 32;
	refShip.CannonerCrew				= 44;
	refShip.SailorCrew					= 109;
	refShip.SpeedRate       			= 12.7;
	refShip.TurnRate        			= 15.0;
	refShip.Price           			= 39000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 4500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3500;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 3;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.49;
	refship.SpeedDependWeight			= 0.37;
	refship.SubSeaDependWeight			= 0.69;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.3;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //
	
	///////////////////////////////////////////////////////////////////////////
	/// ENTERPRISE - Frigate L'Enterprise
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_ENTERPRISE]);
	refShip.Name            			= "Enterprise";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(250);
	refShip.Capacity        			= 2150;
	refShip.CannonsQuantity		= 24;
	refShip.rcannon 							= 10;
	refShip.lcannon 							= 10;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 102;
	refShip.MinCrew         			= 13;
	refShip.BoardingCrew						= 27;
	refShip.GunnerCrew							= 24;
	refShip.CannonerCrew				= 48;
	refShip.SailorCrew					= 112;
	refShip.SpeedRate       			= 11.5;
	refShip.TurnRate        			= 10.0;
	refShip.Price           			= 27000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 4700;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3700;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 3;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.0;
	refship.SpeedDependWeight			= 0.27;
	refship.SubSeaDependWeight			= 0.3;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.3;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	// Privateer
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SLOOPOFWAR]);
	refShip.Name            			= "SloopofWar";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(300);
	refShip.Capacity        			= 1850;
	refShip.CannonsQuantity		= 22;
	refShip.rcannon 						= 9;
	refShip.lcannon 						= 9;
	refShip.fcannon 						= 2;
	refShip.bcannon 						= 2;
	refShip.MaxCrew         			= 100;
	refShip.MinCrew         			= 14;
	refShip.BoardingCrew					= 20;
	refShip.GunnerCrew				= 22;
	refShip.CannonerCrew					= 44;
	refShip.SailorCrew				= 110;
	refShip.SpeedRate					= 11.8;
	refShip.TurnRate        			= 13.0;
	refShip.Price           			= 33000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 4100;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3100;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War					= true;
	refShip.fWindAgainstSpeed			= 4.2;
	refShip.sea_enchantment				= 1.5;
	refShip.lowpolycrew 				= 12;
	refShip.buildtime 				= 80;

	refship.Rocking.y = 0.8;
	refship.Rocking.az = 0.025;
	
	refship.WaterLine = 0.34;
	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 0.74;
	refship.TurnDependWeight = 0.8;
	refship.TurnDependWeight			= 0.35;
	refship.WindAgainstSpeed   = 4.8;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05

	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 3.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 18.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.17;
	refship.Track1.LifeTime = 12.5;
	refship.Track1.Width	= "4.0, 5.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 6.5;
	refship.Track2.Width	= "5.0, 7.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// 20 Gun Brig - Light Brig
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BRIG_20_GUN1_18]);
	refShip.Name            			= "Brig_20_Gun1_18";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(250);
	refShip.Capacity        			= 1850;
	refShip.CannonsQuantity		= 20;
	refShip.rcannon 							= 8;
	refShip.lcannon 							= 8;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 98;
	refShip.MinCrew         			= 12;
	refShip.BoardingCrew				= 26;
	refShip.GunnerCrew					= 20;
	refShip.CannonerCrew				= 40;
	refShip.SailorCrew					= 108;
	refShip.SpeedRate       			= 12.8;
	refShip.TurnRate        			= 13.0;
	refShip.Price           			= 31000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 4100;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3100;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 2.0;
	refShip.sea_enchantment					= 1.8;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.57;
	refship.SpeedDependWeight			= 0.27;
	refship.SubSeaDependWeight			= 0.87;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.3;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	//// schooner_L - Gaff Schooner
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SCHOONER_L]);
	refShip.Name            			= "Schooner_l";
	refship.Soundtype					= "lugger";
	refShip.Class						= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight						= Tonnes2CWT(300);
	refShip.Capacity        			= 1300;
	refShip.CannonsQuantity				= 20;
	refShip.rcannon 					= 8;
	refShip.lcannon 					= 8;
	refShip.fcannon 					= 2;
	refShip.bcannon 					= 2;
	refShip.MaxCrew         			= 92;
	refShip.MinCrew         			= 12;
	refShip.BoardingCrew				= 20;
	refShip.GunnerCrew					= 20;
	refShip.CannonerCrew				= 40;
	refShip.SailorCrew					= 102;
	refShip.SpeedRate					= 11.0;
	refShip.TurnRate        			= 14.5;
	refShip.Price           			= 24000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3900;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2900;
}
	refShip.SP              			= 250;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 9.0;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 40;

	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.03;

	refship.WaterLine					= -0.5;

	refship.SpeedDependWeight			= 0.2;
	refship.SubSeaDependWeight			= 0.2;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 8.0;//boal
	
	refship.InertiaAccelerationX	= 8.0;	refship.InertiaBrakingX		= 8.0;
	refship.InertiaAccelerationY	= 6;		refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 6.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 8;
	refship.Track1.Width	= "1.2, 2.2";
	refship.Track1.Speed	= "7.2, 8.2";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 6;
	refship.Track2.Width	= "2.2, 3.2";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	//// Shnyava
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SHNYAVA]);
	refShip.Name            			= "Shnyava";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(250);
	refShip.Capacity        			= 1850;
	refShip.CannonsQuantity		= 22;
	refShip.rcannon 							= 8;
	refShip.lcannon 							= 8;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         			= 99;
	refShip.MinCrew         			= 10;
	refShip.BoardingCrew						= 23;
	refShip.GunnerCrew							= 22;
	refShip.CannonerCrew				= 44;
	refShip.SailorCrew					= 95;
	refShip.SpeedRate       			= 12.5;
	refShip.TurnRate        			= 14.0;
	refShip.Price           			= 27000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 3800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 2800;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 2.0;
	refShip.sea_enchantment					= 3;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.0;
	refship.SpeedDependWeight			= 0.27;
	refship.SubSeaDependWeight			= 0.3;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.3;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	// Hooker1 - Fast Schooner
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_HOOKER1]);
	refShip.Name            			= "Hooker1";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 8;
	refShip.Weight			= Tonnes2CWT(300);
	refShip.Capacity        			= 1300;
	refShip.CannonsQuantity		= 22;
	refShip.rcannon 						= 9;
	refShip.lcannon 						= 9;
	refShip.fcannon 						= 2;
	refShip.bcannon 						= 2;
	refShip.MaxCrew         			= 98;
	refShip.MinCrew         			= 9;
	refShip.BoardingCrew					= 23;
	refShip.GunnerCrew				= 22;
	refShip.CannonerCrew					= 44;
	refShip.SailorCrew				= 88;
	refShip.SpeedRate       			= 12.1;
	refShip.TurnRate        			= 15.5;
	refShip.Price           			= 20500;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 4050;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3050;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 6.7;
	refShip.sea_enchantment					= 2.0;
	refShip.lowpolycrew = 8;
	refShip.buildtime = 20;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.9;
	refship.SpeedDependWeight			= 0.2;
	refship.SubSeaDependWeight			= 0.6;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 10.0;//boal
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 2.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 9;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "8.0, 10.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7;
	refship.Track2.Width	= "3.0, 4.5";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Brig SS - Fast Brig
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BRIG3]);
	refShip.Name            			= "Brig3";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 12;
	refShip.Weight			= Tonnes2CWT(250);
	refShip.Capacity        			= 1800;
	refShip.CannonsQuantity		= 22;
	refShip.rcannon 							= 9;
	refShip.lcannon 							= 9;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 100;
	refShip.MinCrew         			= 14;
	refShip.BoardingCrew				= 20;
	refShip.GunnerCrew					= 32;
	refShip.CannonerCrew				= 44;
	refShip.SailorCrew					= 116;
	refShip.SpeedRate       			= 12.8;
	refShip.TurnRate        			= 13.0;
	refShip.Price           			= 29000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 5300;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 4300;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 3;
	refShip.lowpolycrew = 12;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.04;
	
	refship.WaterLine							= 0.49;
	refship.SpeedDependWeight			= 0.37;
	refship.SubSeaDependWeight			= 0.69;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.3;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 12;	refship.InertiaBrakingY		= 8;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.Height.Bombs.Y				= 1.0;		refShip.Height.Bombs.DY		= 1.0;
	refShip.Height.Grapes.Y				= 2.0;		refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 15.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y				= 1.0;		refShip.Height.Balls.DY		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.8;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //


///////////////////////////////////////////////////////////////////////////
//class 4
///////////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////
	/// Caravel
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_CARAVEL]);
	refShip.Name            			= "Caravel";
	refship.Soundtype			= "corvette";
	refShip.Class			= 4;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(500);
	refShip.Capacity        			= 4000;
	refShip.CannonsQuantity		= 30;
	refShip.rcannon 							= 13;
	refShip.lcannon 							= 13;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         		= 220;
	refShip.MinCrew         			= 17;
	refShip.BoardingCrew						= 113;
	refShip.GunnerCrew							= 30;
	refShip.CannonerCrew				= 60;
	refShip.SailorCrew					= 320;
	refShip.SpeedRate					= 9.0;
	refShip.TurnRate        			= 7.0;
	refShip.Price           			= 42000;
	if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 9900;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 8900;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed				= 1.2;
	refShip.sea_enchantment					= 1.5;
	refShip.lowpolycrew = 16;
	refShip.buildtime = 40;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	refship.DeckType           = "Medium";
	
	refship.WaterLine							= 0.5;
	refship.SpeedDependWeight			= -0.2;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 4.0;//boal
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 3.0;	refship.InertiaBrakingZ		= 3.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 10;
	refship.Track1.Width	= "4.0, 5.0";
	refship.Track1.Speed	= "7.2, 9.2";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "5.0, 7.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //
	
	///////////////////////////////////////////////////////////////////////////
	/// Corvette
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_CORVETTE]);
	refShip.Name            			= "Corvette";
	refship.Soundtype			= "corvette";
	refShip.Class			= 4;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(600);
	refShip.Capacity        			= 2900;
	refShip.CannonsQuantity		= 30;
	refShip.rcannon 							= 12;
	refShip.lcannon 							= 12;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         		= 150;
	refShip.MinCrew         			= 20;
	refShip.BoardingCrew						= 40;
	refShip.GunnerCrew							= 30;
	refShip.CannonerCrew				= 60;
	refShip.SailorCrew					= 180;
	refShip.SpeedRate					= 13.0;
	refShip.TurnRate        			= 13.0;
	refShip.Price           			= 88000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 7750;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 6750;
}
	refShip.SP              			= 350;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.6;
	refShip.sea_enchantment					= 1.5;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 80;

	refship.Rocking.y = 0.8;
	refship.Rocking.az = 0.025;
	
	refship.WaterLine							= 0.08;
	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 0.38;
	refship.TurnDependWeight			= 0.35;
	refship.WindAgainstSpeed   = 4.8;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 8.0;	refship.InertiaBrakingX		= 8.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 6.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.17;
	refship.Track1.LifeTime = 12.5;
	refship.Track1.Width	= "4.0, 5.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 6.5;
	refship.Track2.Width	= "5.0, 7.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Galeon HEAVY - Heavy Galleon
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_GALEON_H]);
	refShip.Name            			= "Galeon_h";
	refship.Soundtype			= "corvette";
	refShip.Class			= 4;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 24;
	refShip.Weight			= Tonnes2CWT(1100);
	refShip.Capacity        			= 4900;
	refShip.CannonsQuantity		= 38;
	refShip.rcannon 							= 16;
	refShip.lcannon 							= 16;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         			= 330;
	refShip.MinCrew         			= 26;
	refShip.BoardingCrew						= 190;
	refShip.GunnerCrew							= 38;
	refShip.CannonerCrew				= 76;
	refShip.SailorCrew					= 450;
	refShip.SpeedRate					= 8.0;
	refShip.TurnRate        			= 8.0;
	refShip.Price           			= 105000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 13300;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 12300;
}
	refShip.SP              			= 350;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.1;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 80;

	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.02;
	
	refship.WaterLine							= -0.7;

	refship.SpeedDependWeight			= 0.15;
	refship.SubSeaDependWeight			= 0.4;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 2.6;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 4.5;	refship.InertiaBrakingX		= 4.5;
	refship.InertiaAccelerationY	= 3;	refship.InertiaBrakingY		= 3;
	refship.InertiaAccelerationZ	= 4.5;	refship.InertiaBrakingZ		= 4.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.98;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.0;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "5.2, 7.3";
	refship.Track1.Speed	= "5.5, 6.5";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "6.0, 8.0";
	refship.Track2.Speed	= "0.15, 0.25";	

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Galeon - Apostl Felipe
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_FELIPE]);
	refShip.Name            		= "Felipe";
	refship.Soundtype				= "frigate";
	refShip.Class			= 4;
	refShip.Cannon          					= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      	= 20;
	refShip.Weight						= Tonnes2CWT(1100);
	refShip.Capacity        			= 5150;
	refShip.CannonsQuantity		= 30;
	refShip.rcannon 						= 14;
	refShip.lcannon 						= 14;
	refShip.fcannon 						= 0;
	refShip.bcannon 						= 2;
	refShip.MaxCrew         	= 270;
	refShip.MinCrew         	= 17;
	refShip.BoardingCrew			= 163;
	refShip.GunnerCrew				= 30;
	refShip.CannonerCrew			= 60;
	refShip.SailorCrew			= 370;
	refShip.SpeedRate		= 9.4;
	refShip.TurnRate        		= 8.0;
	refShip.Price           	= 125000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              	= 10800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 9800;
}
	refShip.SP              	= 300;
	refShip.AbordageLocation		= "Boarding Deck_01";
	refship.Type.Merchant		= true;
	refship.Type.War		= false;
	refShip.fWindAgainstSpeed		= 1.1;
	refShip.sea_enchantment		= 1.2;
	refShip.lowpolycrew 		= 20;
	refShip.buildtime 		= 80;

	
	refship.Rocking.y 		= 0.4;
	refship.Rocking.az 		= 0.02;
	
	refship.WaterLine		= 0.0;

	refship.SpeedDependWeight	= 0.15;
	refship.SubSeaDependWeight	= 0.3;
	refship.TurnDependWeight	= 0.2;
	refship.WindAgainstSpeed   	= 2.6;//boal
	refship.CabinType          	= "Cabin"; // boal 28.03.05
	refship.DeckType           	= "Big";
	
	refship.InertiaAccelerationX	= 4.5;	refship.InertiaBrakingX		= 4.5;
	refship.InertiaAccelerationY	= 3;	refship.InertiaBrakingY		= 3;
	refship.InertiaAccelerationZ	= 4.5;	refship.InertiaBrakingZ		= 4.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale	= 0.98;
	refShip.GeraldSails.rey_b3.vscale	= 0.8;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.0;
	refship.Track1.LifeTime 	= 14.5;
	refship.Track1.Width		= "5.2, 7.3";
	refship.Track1.Speed		= "5.5, 6.5";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 8.5;
	refship.Track2.Width		= "6.0, 8.0";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Frigate Surprise
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SURPRISE]);
	refShip.Name            			= "Surprise";
	refship.Soundtype			= "corvette";
	refShip.Class			= 4;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 3200;
	refShip.CannonsQuantity				= 30;
	refShip.rcannon 							= 14;
	refShip.lcannon 							= 14;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 160;
	refShip.MinCrew         			= 18;
	refShip.BoardingCrew						= 52;
	refShip.GunnerCrew							= 30;
	refShip.CannonerCrew				= 60;
	refShip.SailorCrew					= 190;
	refShip.SpeedRate					= 12.8;
	refShip.TurnRate        			= 12.5;
	refShip.Price           			= 110000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 7500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP              			= 6500;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.0;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.2;
	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.8;
	refship.WindAgainstSpeed   = 4.5;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;

        refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 0.5;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 10.0; refShip.Height.Knippels.DY = 8.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 0.5;

	refShip.GeraldSails.rey_b1 = 1;
	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b1.vscale = 0.9;
	refShip.GeraldSails.rey_b2.vscale = 0.7;
	refShip.GeraldSails.rey_b3.vscale = 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Fast Frigate - Light Corvette
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_CORVFRIG2_50]);
	refShip.Name            			= "CorvFrig2_50";
	refship.Soundtype			= "corvette";
	refShip.Class			= 4;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 2600;
	refShip.CannonsQuantity				= 32;
	refShip.rcannon 							= 13;
	refShip.lcannon 							= 13;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         			= 171;
	refShip.MinCrew         			= 17;
	refShip.BoardingCrew						= 58;
	refShip.GunnerCrew							= 32;
	refShip.CannonerCrew				= 64;
	refShip.SailorCrew					= 200;
	refShip.SpeedRate					= 13.0;
	refShip.TurnRate        			= 14.0;
	refShip.Price           			= 80000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 6100;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 5100;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.1;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.15;
	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.8;
	refship.WindAgainstSpeed   = 4.5;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;

        refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 0.5;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 10.0; refShip.Height.Knippels.DY = 8.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 0.5;

	refShip.GeraldSails.rey_b1 = 1;
	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b1.vscale = 0.9;
	refShip.GeraldSails.rey_b2.vscale = 0.7;
	refShip.GeraldSails.rey_b3.vscale = 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// RaaFrigate
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_RaaFrigate]);
	refShip.Name            			= "RaaFrigate";
	refship.Soundtype			= "corvette";
	refShip.Class			= 4;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 3400;
	refShip.CannonsQuantity				= 32;
	refShip.rcannon 							= 15;
	refShip.lcannon 							= 15;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 0;
	refShip.MaxCrew         			= 155;
	refShip.MinCrew         			= 18;
	refShip.BoardingCrew						= 51;
	refShip.GunnerCrew							= 32;
	refShip.CannonerCrew				= 64;
	refShip.SailorCrew					= 70;
	refShip.SpeedRate					= 12.9;
	refShip.TurnRate        			= 12.6;
	refShip.Price           			= 113000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 6500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 5500;
}
	refShip.SP              			= 300;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.0;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.3;
	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.8;
	refship.WindAgainstSpeed   = 4.5;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;

        refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 0.5;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 10.0; refShip.Height.Knippels.DY = 8.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 0.5;

	refShip.GeraldSails.rey_b1 = 1;
	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b1.vscale = 0.9;
	refShip.GeraldSails.rey_b2.vscale = 0.7;
	refShip.GeraldSails.rey_b3.vscale = 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// BlackPearl 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BLACKPEARL]);
	refShip.Name            			= "BlackPearl";
	refship.Soundtype			= "frigate";
	refShip.Class			= 4;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 4800;
	refShip.CannonsQuantity		= 36;
	refShip.rcannon 							= 16;
	refShip.lcannon 							= 16;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 190;
	refShip.MinCrew         			= 16;
	refShip.BoardingCrew					= 66;
	refShip.GunnerCrew				= 36;
	refShip.CannonerCrew					= 72;
	refShip.SailorCrew							= 280;
	refShip.SpeedRate       			= 13.5;
	refShip.TurnRate        			= 11.0;
	refShip.Price           			= 70000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 7800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 6800;
}
	refShip.SP              			= 350;
	refship.EmblemedSails.normalTex = "ships\sail_BlackPearl.tga";
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.CanEncounter				= false;
	refship.Type.Merchant				= true;
	refship.Type.War				= true;
	refShip.fWindAgainstSpeed			= 4.0;
	refShip.sea_enchantment				= 1.2;
	refShip.lowpolycrew 				= 20;
	refShip.buildtime 				= 100;

	
	refship.Rocking.y 				= 0.4;
	refship.Rocking.az 				= 0.035;
	
	refship.WaterLine				= -0.7;

	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   			= 3.6;//boal
	refship.CabinType          			= "Cabin"; // boal 28.03.05
	refship.DeckType           			= "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;
	
	refShip.GeraldSails.rey_b1			= 1;
	refShip.GeraldSails.rey_b2			= 1;
	refShip.GeraldSails.rey_b3			= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable				= true;
	refship.Track1.ZStart				= 0.20;
	refship.Track1.LifeTime 			= 14.5;
	refship.Track1.Width				= "3.7, 3.9";
	refship.Track1.Speed				= "7.0, 8.0";

	refship.Track2.ZStart				= -0.15;
	refship.Track2.LifeTime 			= 8.5;
	refship.Track2.Width				= "8.0, 9.0";
	refship.Track2.Speed				= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	// Nightmare
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_NIGHTMARE]);
	refShip.Name            			= "Nightmare";
	refship.Soundtype			= "frigate";
	refShip.Class			= 4;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 3500;
	refShip.CannonsQuantity		= 38;
	refShip.rcannon 							= 18; //might be 14
	refShip.lcannon 							= 18; // might be 14
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 0;
	refShip.MaxCrew         			= 200;
	refShip.MinCrew         			= 21;
	refShip.BoardingCrew				= 65;
	refShip.GunnerCrew				= 44;
	refShip.CannonerCrew				= 88;
	refShip.SailorCrew				= 330;
	refShip.SpeedRate       			= 12.2;
	refShip.TurnRate        			= 11.0;
	refShip.Price           			= 140000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 6800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 5800;
}
	refShip.SP              			= 350;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War					= true;
	refShip.fWindAgainstSpeed				= 3.2;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;

	refship.WaterLine = 0.0;
	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 0.9;
	refship.TurnDependWeight = 0.8;
	refship.WindAgainstSpeed   = 3.6;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 10;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 2.0;

	refShip.Height.Bombs.Y				= 3.0;	refShip.Height.Bombs.DY		= 1.5;
	refShip.Height.Grapes.Y				= 4.5;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 24.0;	refShip.Height.Knippels.DY	= 17.0;
	refShip.Height.Balls.Y				= 3.0;	refShip.Height.Balls.DY		= 1.5;
	
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	///  Unicorn - Frigate
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_UNICORN]);
	refShip.Name            			= "Unicorn";
	refship.Soundtype						= "frigate";
	refShip.Class				= 4;
	refShip.Cannon          					= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 20;
	refShip.Weight									= Tonnes2CWT(1000);
	refShip.Capacity        		= 3200;
	refShip.CannonsQuantity		= 38;
	refShip.rcannon 									= 18;
	refShip.lcannon 									= 18;
	refShip.fcannon 									= 2;
	refShip.bcannon 									= 0;
	refShip.MaxCrew         		= 164;
	refShip.MinCrew         			= 15;
	refShip.BoardingCrew			= 35;
	refShip.GunnerCrew					= 38;
	refShip.CannonerCrew				= 76;
	refShip.SailorCrew			= 270;
	refShip.SpeedRate       				= 12.9;
	refShip.TurnRate        			= 12.0;
	refShip.Price           		= 230000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              	= 8400;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 7400;
}
	refShip.SP              	= 350;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant			= false;
	refship.Type.War			= true;
	refShip.fWindAgainstSpeed	= 3.0;
	refShip.sea_enchantment		= 1.2;
	refShip.lowpolycrew 		= 20;
	refShip.buildtime 		= 220;

	
	refship.Rocking.y 		= 0.4;
	refship.Rocking.az 		= 0.035;
	
	refship.WaterLine		= -0.35;

	refship.SpeedDependWeight	= 0.3;
	refship.SubSeaDependWeight	= 1.0;
	refship.TurnDependWeight	= 0.3;
	refship.WindAgainstSpeed  	= 3.6;//boal
	refship.CabinType          	= "Cabin"; // boal 28.03.05
	refship.DeckType           	= "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;
	
	refShip.Height.Bombs.Y		= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y		= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y	= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y		= 1.0;	refShip.Height.Balls.DY		= 0.5;
	
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1.vscale	= 0.9;
	refShip.GeraldSails.rey_b2.vscale	= 0.7;
	refShip.GeraldSails.rey_b3.vscale	= 0.7;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.20;
	refship.Track1.LifeTime 	= 14.5;
	refship.Track1.Width		= "3.7, 3.9";
	refship.Track1.Speed		= "7.0, 8.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 8.5;
	refship.Track2.Width		= "8.0, 9.0";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //


///////////////////////////////////////////////////////////////////////////
//class 3
///////////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////
	/// Frigate 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_FRIGATE]);
	refShip.Name            			= "Frigate";
	refship.Soundtype			= "frigate";
	refShip.Class			= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 20;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 3500;
	refShip.CannonsQuantity		= 46;
	refShip.rcannon 							= 20;
	refShip.lcannon 							= 20;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         		= 213;
	refShip.MinCrew         			= 22;
	refShip.BoardingCrew						= 53;
	refShip.GunnerCrew							= 46;
	refShip.CannonerCrew				= 92;
	refShip.SailorCrew					= 342;
	refShip.SpeedRate       			= 12.7;
	refShip.TurnRate        			= 13.0;
	refShip.Price           			= 161000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 8400;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 7400;
}
	refShip.SP              			= 350;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.0;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;

	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.50;

	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.6;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;
	
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //
	
	///////////////////////////////////////////////////////////////////////////
	/// Lineship - Heavy Lineship
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_LINESHIP]);
	refShip.Name            			= "Lineship";
	refship.Soundtype			= "lineship";
	refShip.Class			= 3;   //     
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 32;
	refShip.Weight			= Tonnes2CWT(2000);
	refShip.Capacity        			= 4350;
	refShip.CannonsQuantity		= 60;
	refShip.rcannon 							= 28;
	refShip.lcannon 							= 28;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         		= 290;
	refShip.MinCrew         		= 26;
	refShip.BoardingCrew					= 84;
	refShip.GunnerCrew				= 60;
	refShip.CannonerCrew				= 120;
	refShip.SailorCrew					= 450;
	refShip.SpeedRate					= 10.0;
	refShip.TurnRate        			= 9.8;
	refShip.Price           			= 220000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 10800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 9800;
}
	refShip.SP              			= 400;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.5;
	refShip.sea_enchantment					= 1.1;
	refShip.lowpolycrew = 24;
	refShip.buildtime = 120;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
		
	refship.WaterLine					= 0.0;

	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 0.69;
	refship.TurnDependWeight			= 0.4;
	refship.WindAgainstSpeed            = 1.7;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 4.5;	refship.InertiaBrakingX		= 4.0;
	refship.InertiaAccelerationY	= 3.5;	refship.InertiaBrakingY		= 3;
	refship.InertiaAccelerationZ	= 4.5;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.8;
	refShip.GeraldSails.rey_b2.vscale		= 0.6;
	refShip.GeraldSails.rey_b3.vscale		= 0.6;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.15;
	refship.Track1.LifeTime = 16.5;
	refship.Track1.Width	= "3.0, 4.0";
	refship.Track1.Speed	= "8.0, 8.0";

	refship.Track2.ZStart	= -0.25;
	refship.Track2.LifeTime = 10.5;
	refship.Track2.Width	= "6.0, 7.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// QueenAnnesRevenge
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_QueenAnnesRevenge]);
	refShip.Name            			= "QueenAnnesRevenge";
	refship.Soundtype			= "frigate";
	refShip.Class			= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 5000;
	refShip.CannonsQuantity		= 44;
	refShip.rcannon 							= 20;
	refShip.lcannon 							= 20;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 210;
	refShip.MinCrew         			= 16;
	refShip.BoardingCrew					= 62;
	refShip.GunnerCrew				= 44;
	refShip.CannonerCrew					= 88;
	refShip.SailorCrew							= 260;
	refShip.SpeedRate       			= 13.5;
	refShip.TurnRate        			= 10.0;
	refShip.Price           			= 70000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 7800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 6800;
}
	refShip.SP              			= 350;
	refship.EmblemedSails.normalTex = "ships\sail_QueenAnnesRevenge.tga";
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.CanEncounter				= true;
	refship.Type.Merchant				= true;
	refship.Type.War				= true;
	refShip.fWindAgainstSpeed			= 4.0;
	refShip.sea_enchantment				= 1.2;
	refShip.lowpolycrew 				= 20;
	refShip.buildtime 				= 100;

	
	refship.Rocking.y 				= 0.4;
	refship.Rocking.az 				= 0.035;
	
	refship.WaterLine				= 0.5;

	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   			= 3.6;//boal
	refship.CabinType          			= "Cabin"; // boal 28.03.05
	refship.DeckType           			= "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;
	
	refShip.GeraldSails.rey_b1			= 1;
	refShip.GeraldSails.rey_b2			= 1;
	refShip.GeraldSails.rey_b3			= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable				= true;
	refship.Track1.ZStart				= 0.20;
	refship.Track1.LifeTime 			= 14.5;
	refship.Track1.Width				= "3.7, 3.9";
	refship.Track1.Speed				= "7.0, 8.0";

	refship.Track2.ZStart				= -0.15;
	refship.Track2.LifeTime 			= 8.5;
	refship.Track2.Width				= "8.0, 9.0";
	refship.Track2.Speed				= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Revenge                       
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_REVENGE]);
	refShip.Name            			= "Revenge";
	refship.Soundtype				= "frigate";
	refShip.Class					= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight					= Tonnes2CWT(1100);
	refShip.Capacity        			= 5200;
	refShip.CannonsQuantity				= 40;
	refShip.rcannon 				= 19;
	refShip.lcannon 				= 19;
	refShip.fcannon 				= 0;
	refShip.bcannon 				= 2;

	refShip.MaxCrew         			= 240;
	refShip.MinCrew         			= 16;
	refShip.BoardingCrew				= 104;
	refShip.GunnerCrew				= 40;
	refShip.CannonerCrew				= 80;
	refShip.SailorCrew				= 230;

	refShip.SpeedRate				= 8.0;
	refShip.TurnRate        			= 11.0;

	refShip.Price           			= 105000;

		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 6800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 5800;
}
	refShip.SP              			= 350;

	refship.CabinType                               = "Cabin_Small"; // boal 28.03.05
	refship.DeckType                                = "Low";
	refship.CabinType          			= "Cabin_Medium"; // boal 28.03.05
	refship.DeckType           			= "Medium";
	refship.CabinType          	                = "Cabin"; // boal 28.03.05
    	refship.DeckType           	                = "Big";
	refShip.AbordageLocation			= "BOARDING_SMALL_DECK";
	refShip.AbordageLocation	                = "Boarding Deck_01";
	refShip.AbordageLocation			= "Boarding Deck_02";

	refship.Type.Merchant				= true;
	refship.Type.War				= true;

	refShip.fWindAgainstSpeed			= 1.6;
	refShip.sea_enchantment				= 1.2;
	refShip.lowpolycrew                             = 20;
	refShip.buildtime                               = 80;


	refship.Rocking.y                               = 0.4;
	refship.Rocking.az                              = 0.02;

	refship.WaterLine				= 0.0;

	refship.SpeedDependWeight			= 0.15;
	refship.SubSeaDependWeight			= 0.3;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed                        = 2.6;//boal

	refship.InertiaAccelerationX	= 4.5;	refship.InertiaBrakingX		= 4.5;
	refship.InertiaAccelerationY	= 3;	refship.InertiaBrakingY		= 3;
	refship.InertiaAccelerationZ	= 4.5;	refship.InertiaBrakingZ		= 4.5;

	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.98;
	refShip.GeraldSails.rey_b3.vscale		= 0.8;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.0;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "5.2, 7.3";
	refship.Track1.Speed	= "5.5, 6.5";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "6.0, 8.0";
	refship.Track2.Speed	= "0.15, 0.25";

	///////////////////////////////////////////////////////////////////////////
	/// Boussole
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BOUSSOLE]);
	refShip.Name 				= "Boussole";
	refship.Soundtype 				= "frigate";
	refShip.Class 				= 3;
	refShip.Cannon 			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber 			= 16;
	refShip.Weight 								= Tonnes2CWT(1000);
	refShip.Capacity 			= 3500;
	refShip.CannonsQuantity 		= 42;
	refShip.rcannon 					= 19;
	refShip.lcannon 					= 19;
	refShip.fcannon 					= 2;
	refShip.bcannon 					= 2;
	refShip.MaxCrew 			= 210;
	refShip.MinCrew 			= 20;
	refShip.BoardingCrew 					= 64;
	refShip.GunnerCrew 			= 42;
	refShip.CannonerCrew 					= 84;
	refShip.SailorCrew 			= 310;
	refShip.SpeedRate 				= 12.3;
	refShip.TurnRate 			= 13.0;
	refShip.Price 				= 145000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP 				= 7500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 6500;
}
	refShip.SP  				= 350;
	refShip.AbordageLocation 	= "Boarding Deck_01";
	refship.Type.Merchant 				= false;
	refship.Type.War 					= true;
	refShip.fWindAgainstSpeed 	= 3.3;
	refShip.sea_enchantment 	= 1.2;
	refShip.lowpolycrew 		= 20;
	refShip.buildtime 		= 100;

	refship.Rocking.y 		= 0.4;
	refship.Rocking.az 		= 0.035;
	refship.WaterLine 		= 0.50;

	refship.SpeedDependWeight 	= 0.3;
	refship.SubSeaDependWeight 	= 1.0;
	refship.TurnDependWeight 	= 0.8;
	refship.WindAgainstSpeed 	= 4.5;//boal
	refship.CabinType 		= "Cabin"; // boal 28.03.05
	refship.DeckType 		= "Big";

	refship.InertiaAccelerationX = 5.0; refship.InertiaBrakingX = 5.0;
	refship.InertiaAccelerationY = 4; refship.InertiaBrakingY = 4;
	refship.InertiaAccelerationZ = 5.0; refship.InertiaBrakingZ = 5.0;

	refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 0.5;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 10.0; refShip.Height.Knippels.DY = 8.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 0.5;
	
	refShip.GeraldSails.rey_b1 = 1;
	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b1.vscale = 0.9;
	refShip.GeraldSails.rey_b2.vscale = 0.7;
	refShip.GeraldSails.rey_b3.vscale = 0.7;

	refship.Track.Enable = true;
	refship.Track1.ZStart = 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width = "3.7, 3.9";
	refship.Track1.Speed = "7.0, 8.0";

	refship.Track2.ZStart = -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width = "8.0, 9.0";
	refship.Track2.Speed = "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	// Salamander
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SALAMANDER]);
	refShip.Name            			= "Salamander";
	refship.Soundtype					= "frigate";
	refShip.Class					= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 16;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 3500;
	refShip.CannonsQuantity		= 44;
	refShip.rcannon 							= 19;
	refShip.lcannon 							= 19;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         		= 217;
	refShip.MinCrew         		= 20;
	refShip.BoardingCrew						= 65;
	refShip.GunnerCrew				= 44;
	refShip.CannonerCrew				= 88;
	refShip.SailorCrew					= 300;
	refShip.SpeedRate       			= 12.8;
	refShip.TurnRate        			= 13.5;
	refShip.Price           			= 156000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 7700;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 6700;
}
	refShip.SP              			= 350;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War					= true;
	refShip.fWindAgainstSpeed				= 3.3;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;

	refship.WaterLine = 0.1;
	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 0.9;
	refship.TurnDependWeight = 0.8;
	refship.WindAgainstSpeed   = 3.6;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";

	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 10;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 2.0;

	refShip.Height.Bombs.Y			= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y			= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y		= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y			= 1.0;	refShip.Height.Balls.DY		= 0.5;
	
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Linefrigate
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_LINEFRIGATE]);
	refShip.Name            			= "Linefrigate";
	refship.Soundtype					= "frigate";
	refShip.Class						= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 24;
	refShip.Weight						= Tonnes2CWT(1700);
	refShip.Capacity        			= 3400;
	refShip.CannonsQuantity				= 40;
	refShip.rcannon 					= 17;
	refShip.lcannon 					= 17;
	refShip.fcannon 					= 2;
	refShip.bcannon 					= 4;
	refShip.MaxCrew         			= 240;
	refShip.MinCrew         			= 22;
	refShip.BoardingCrew				= 98;
	refShip.GunnerCrew					= 40;
	refShip.CannonerCrew				= 80;
	refShip.SailorCrew					= 330;
	refShip.SpeedRate       			= 11.5;
	refShip.TurnRate        			= 13.0;
	refShip.Price           			= 380000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 8000;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 7000;
}
	refShip.SP              			= 350;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;

	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.86;
	
	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.5;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;
	
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";
	
	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //
	///////////////////////////////////////////////////////////////////////////
	// Dutch Two-decker
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_TWODECKER1_47]);
	refShip.Name            			= "TwoDecker1_47";
	refship.Soundtype			= "linship";
	refShip.Class			= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 20;
	refShip.Weight			= Tonnes2CWT(550);
	refShip.Capacity        			= 4100;
	refShip.CannonsQuantity		= 54;
	refShip.rcannon 							= 23;
	refShip.lcannon 							= 23;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 6;
	refShip.MaxCrew         			= 278;
	refShip.MinCrew         			= 20;
	refShip.BoardingCrew						= 96;
	refShip.GunnerCrew				= 54;
	refShip.CannonerCrew						= 108;
	refShip.SailorCrew				= 260;
	refShip.SpeedRate       				= 12.3;
	refShip.TurnRate        			= 12.0;
	refShip.Price           			= 120000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 8550;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 7550;
}
	refShip.SP              			= 400;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.5;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;

	refship.WaterLine = 1.2;
	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 1.1;
	refship.TurnDependWeight = 0.8;
	refship.WindAgainstSpeed   = 3.6;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";

	refship.InertiaAccelerationX	= 3.0;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 14;	refship.InertiaBrakingY		= 5;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 3.0;

	refShip.Height.Bombs.Y				= 3.0;	refShip.Height.Bombs.DY		= 1.5;
	refShip.Height.Grapes.Y				= 4.5;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 24.0;	refShip.Height.Knippels.DY	= 17.0;
	refShip.Height.Balls.Y				= 3.0;	refShip.Height.Balls.DY		= 1.5;
	
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //
	
	///////////////////////////////////////////////////////////////////////////
	/// USS_CONSTITUTION - Constitution
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_USS_CONSTITUTION]);
	refShip.Name 				= "USS_Constitution";
	refship.Soundtype 				= "frigate";
	refShip.Class 				= 3;
	refShip.Cannon 				= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber 				= 24;
	refShip.Weight 				= Tonnes2CWT(1000);
	refShip.Capacity 				= 4200;
	refShip.CannonsQuantity 			= 56;
	refShip.rcannon 							= 26;
	refShip.lcannon 							= 26;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew 				= 263;
	refShip.MinCrew 				= 20;
	refShip.BoardingCrew 					= 75;
	refShip.GunnerCrew 				= 56;
	refShip.CannonerCrew 				= 112;
	refShip.SailorCrew 					= 400;
	refShip.SpeedRate 					= 13.5;
	refShip.TurnRate 				= 12.0;
	refShip.Price 					= 180000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP 					= 9000;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 8000;
}
	refShip.SP 					= 400;
	refShip.AbordageLocation = "Boarding Deck_01";
	refship.Type.Merchant 				= false;
	refship.Type.War			        = true;
	refShip.fWindAgainstSpeed = 3.0;
	refShip.sea_enchantment = 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;

	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	refship.WaterLine = 0.50;

	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 1.0;
	refship.TurnDependWeight = 0.8;
	refship.WindAgainstSpeed = 5.2; //boal
	refship.CabinType = "Cabin"; // boal 28.03.05
	refship.DeckType = "Big";

	refship.InertiaAccelerationX = 0.2; refship.InertiaBrakingX = 2.0;
	refship.InertiaAccelerationY = 10; refship.InertiaBrakingY = 4;
	refship.InertiaAccelerationZ = 4.0; refship.InertiaBrakingZ = 2.0;

	refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 0.5;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 10.0; refShip.Height.Knippels.DY = 8.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 0.5;

	refShip.GeraldSails.rey_b1 = 1;
	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b1.vscale = 0.9;
	refShip.GeraldSails.rey_b2.vscale = 0.7;
	refShip.GeraldSails.rey_b3.vscale = 0.7;

	refship.Track.Enable = true;
	refship.Track1.ZStart = 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width = "3.7, 3.9";
	refship.Track1.Speed = "7.0, 8.0";

	refship.Track2.ZStart = -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width = "8.0, 9.0";
	refship.Track2.Speed = "0.15, 0.25"; 

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// La Licorne 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_LA_LICORNE]);
	refShip.Name            			= "La_Licorne";
	refship.Soundtype			= "frigate";
	refShip.Class			= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 20;
	refShip.Weight			= Tonnes2CWT(1100);
	refShip.Capacity        			= 5100;
	refShip.CannonsQuantity				= 52;
	refShip.rcannon 							= 22;
	refShip.lcannon 							= 22;
	refShip.fcannon 							= 4;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         				= 283;
	refShip.MinCrew         				= 24;
	refShip.BoardingCrew				= 103;
	refShip.GunnerCrew				= 52;
	refShip.CannonerCrew				= 104;
	refShip.SailorCrew				= 200;
	refShip.SpeedRate       				= 11.7;
	refShip.TurnRate        			= 10.6;
	refShip.Price           			= 220000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 9700;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 8700;
}
	refShip.SP              			= 400;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.2;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= -0.2;

	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 0.0;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 3.6;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 10;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 2.0;
	
	refShip.Height.Bombs.Y				= 3.0;	refShip.Height.Bombs.DY		= 1.5;
	refShip.Height.Grapes.Y				= 4.5;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 24.0;	refShip.Height.Knippels.DY	= 17.0;
	refShip.Height.Balls.Y				= 3.0;	refShip.Height.Balls.DY		= 1.5;
	
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Cursed Flying Dutchman - The Flying Dutchman
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_CURSEDDUTCHMAN]);
	refShip.Name 					= "CursedDutchman";
	refship.Soundtype 				= "manowar";
	refShip.Class 					= 3;
	refShip.Cannon 								= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber 				= 42;
	refShip.Weight 								= Tonnes2CWT(2200);
	refShip.Capacity 				= 5300;
	refShip.CannonsQuantity 		= 54;
	refShip.rcannon 							= 24;
	refShip.lcannon 							= 24;
	refShip.fcannon 							= 6;
	refShip.bcannon 							= 0;
	refShip.MaxCrew 			= 300;
	refShip.MinCrew 			= 26;
	refShip.BoardingCrew 					= 112;
	refShip.GunnerCrew 				= 54;
	refShip.CannonerCrew 					= 108;
	refShip.SailorCrew 				= 422;
	refShip.SpeedRate 					= 13.5;
	refShip.TurnRate 				= 10.0;
	refShip.Price 					= 200000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP 					= 11900;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 10900;
}
	refShip.SP 					= 400;
	refship.EmblemedSails.normalTex = "ships\sail_Dutchman.tga";
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.CanEncounter					= false;
	refship.Type.Merchant					= true;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 1.1;
	refShip.lowpolycrew = 24;
	refShip.buildtime = 120;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.5;

	refship.SpeedDependWeight			= 0.35;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.4;
	refship.WindAgainstSpeed   = 3.8;//boal
	refship.CabinType          = "CabineFDM"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 4.0;	refship.InertiaBrakingX		= 3.5;
	refship.InertiaAccelerationY	= 3.0;		refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.8;
	refShip.GeraldSails.rey_b2.vscale		= 0.65;
	refShip.GeraldSails.rey_b3.vscale		= 0.55;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.25;
	refship.Track1.LifeTime = 9.5;
	refship.Track1.Width	= "7.0, 7.5";
	refship.Track1.Speed	= "8.0, 9.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "8.0, 10.0";
	refship.Track2.Speed	= "1.0, 2.0";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// RN Battle Frigate - Fast Battle Frigate
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_RN_BATTLEFRIGATE]);
	refShip.Name 				= "RN_BattleFrigate";
	refship.Soundtype 				= "frigate";
	refShip.Class 				= 3;
	refShip.Cannon 				= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber 				= 24;
	refShip.Weight 				= Tonnes2CWT(1000);
	refShip.Capacity 				= 4600;
	refShip.CannonsQuantity 			= 54;
	refShip.rcannon 							= 26;
	refShip.lcannon 							= 26;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 2;
	refShip.MaxCrew 				= 290;
	refShip.MinCrew 				= 24;
	refShip.BoardingCrew 					= 104;
	refShip.GunnerCrew 				= 54;
	refShip.CannonerCrew 				= 108;
	refShip.SailorCrew 					= 380;
	refShip.SpeedRate 					= 12.7;
	refShip.TurnRate 				= 12.0;
	refShip.Price 					= 230000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP 					= 10800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 9800;
}
	refShip.SP 					= 400;
	refShip.AbordageLocation = "Boarding Deck_01";
	refship.Type.Merchant			 = false;
	refship.Type.War 			 = true;
	refShip.fWindAgainstSpeed = 3.5;
	refShip.sea_enchantment = 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;

	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;
	refship.WaterLine = 0.50;

	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 1.0;
	refship.TurnDependWeight = 0.8;
	refship.WindAgainstSpeed = 4.5;//boal
	refship.CabinType = "Cabin"; // boal 28.03.05
	refship.DeckType = "Big";

	refship.InertiaAccelerationX = 5.0; refship.InertiaBrakingX = 5.0;
	refship.InertiaAccelerationY = 4; refship.InertiaBrakingY = 4;
	refship.InertiaAccelerationZ = 5.0; refship.InertiaBrakingZ = 5.0;

	refShip.Height.Bombs.Y = 1.0; refShip.Height.Bombs.DY = 0.5;
	refShip.Height.Grapes.Y = 2.0; refShip.Height.Grapes.DY = 1.0;
	refShip.Height.Knippels.Y = 10.0; refShip.Height.Knippels.DY = 8.0;
	refShip.Height.Balls.Y = 1.0; refShip.Height.Balls.DY = 0.5;

	refShip.GeraldSails.rey_b1 = 1;
	refShip.GeraldSails.rey_b2 = 1;
	refShip.GeraldSails.rey_b3 = 1;
	refShip.GeraldSails.rey_b1.vscale = 0.9;
	refShip.GeraldSails.rey_b2.vscale = 0.7;
	refShip.GeraldSails.rey_b3.vscale = 0.7;

	refship.Track.Enable = true;
	refship.Track1.ZStart = 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width = "3.7, 3.9";
	refship.Track1.Speed = "7.0, 8.0";

	refship.Track2.ZStart = -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width = "8.0, 9.0";
	refship.Track2.Speed = "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Fast Galleon - Golden Hind
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_FASTGALLEON1]);
	refShip.Name            			= "FastGalleon1";
	refship.Soundtype					= "corvette";
	refShip.Class					= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 24;
	refShip.Weight			= Tonnes2CWT(800);
	refShip.Capacity        			= 5900;
	refShip.CannonsQuantity		= 40;
	refShip.rcannon 							= 16;
	refShip.lcannon 							= 16;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         			= 290;
	refShip.MinCrew         			= 25;
	refShip.BoardingCrew						= 145;
	refShip.GunnerCrew							= 40;
	refShip.CannonerCrew				= 80;
	refShip.SailorCrew					= 450;
	refShip.SpeedRate					= 9.1;
	refShip.TurnRate        			= 9.7;
	refShip.Price           			= 111000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 13400;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 12400;
}
	refShip.SP              			= 350;
	refShip.AbordageLocation			= "Boarding Deck_02";
	refship.Type.Merchant					= true;
	refship.Type.War						= false;
	refShip.fWindAgainstSpeed				= 1.2;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 60;

	refship.Rocking.y = 0.45;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= -0.7;
	refship.SpeedDependWeight			= 0.15;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.2;
	refship.WindAgainstSpeed   = 1.0;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	refship.DeckType           = "Medium";
	
	refship.InertiaAccelerationX	= 4.0;	refship.InertiaBrakingX		= 4.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 4.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 16.5;
	refship.Track1.Width	= "5.2, 7.3";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 10.5;
	refship.Track2.Width	= "6.0, 8.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //


///////////////////////////////////////////////////////////////////////////
//class 2
///////////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////
	/// Warship 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_WARSHIP]);
	refShip.Name            			= "Warship";  // 
	refship.Soundtype			= "lineship";
	refShip.Class			= 2;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 36;
	refShip.Weight			= Tonnes2CWT(2500);
	refShip.Capacity        			= 5200;
	refShip.CannonsQuantity		= 66;
	refShip.rcannon 							= 30;
	refShip.lcannon 							= 30;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         		= 420;
	refShip.MinCrew         		= 28;
	refShip.BoardingCrew						= 194;
	refShip.GunnerCrew				= 66;
	refShip.CannonerCrew				= 132;
	refShip.SailorCrew					= 520;
	refShip.SpeedRate					= 10.5;
	refShip.TurnRate        			= 9.2;
	refShip.Price           			= 250000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 14900;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 13900;
}
	refShip.SP              			= 400;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.4;
	refShip.sea_enchantment					= 1.1;
	refShip.lowpolycrew = 24;
	refShip.buildtime = 120;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.85;

	refship.SpeedDependWeight			= 0.35;
	refship.SubSeaDependWeight			= 1.5;
	refship.TurnDependWeight			= 0.4;
	refship.WindAgainstSpeed   = 1.0;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 4.0;	refship.InertiaBrakingX		= 3.5;
	refship.InertiaAccelerationY	= 3.0;		refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.8;
	refShip.GeraldSails.rey_b2.vscale		= 0.65;
	refShip.GeraldSails.rey_b3.vscale		= 0.55;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.25;
	refship.Track1.LifeTime = 9.5;
	refship.Track1.Width	= "7.0, 7.5";
	refship.Track1.Speed	= "8.0, 9.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "8.0, 10.0";
	refship.Track2.Speed	= "1.0, 2.0";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //
	
	///////////////////////////////////////////////////////////////////////////
	/// Warship Poseidon
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_POSEIDON]);
	refShip.Name            			= "Poseidon";
	refship.Soundtype			= "lineship";
	refShip.Class			= 2;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 36;
	refShip.Weight			= Tonnes2CWT(2500);
	refShip.Capacity        			= 5200;
	refShip.CannonsQuantity		= 66;
	refShip.rcannon 				= 30;
	refShip.lcannon 				= 30;
	refShip.fcannon 				= 2;
	refShip.bcannon 				= 4;
	refShip.MaxCrew         		= 623;
	refShip.MinCrew         		= 32;
	refShip.BoardingCrew					= 393;
	refShip.GunnerCrew				= 66;
	refShip.CannonerCrew				= 132;
	refShip.SailorCrew					= 618;
	refShip.SpeedRate			= 11.1;
	refShip.TurnRate        			= 9.0;
	refShip.Price           			= 423000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 15500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 14500;
}
	refShip.SP              			= 400;
	refShip.AbordageLocation	= "Boarding Deck_01";
	refship.Type.Merchant		= false;
	refship.Type.War		= true;
	refShip.fWindAgainstSpeed	= 1.1;
	refShip.sea_enchantment		= 1.1;
	refShip.lowpolycrew 		= 24;
	refShip.buildtime 		= 120;

	refship.Rocking.y 		= 0.5;
	refship.Rocking.az 		= 0.035;
	
	refship.WaterLine		= 0.05;

	refship.SpeedDependWeight	= 0.35;
	refship.SubSeaDependWeight	= 1.0;
	refship.TurnDependWeight	= 0.4;
	refship.WindAgainstSpeed   	= 1.0;//boal
	refship.CabinType          	= "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           	= "Big";
	
	refship.InertiaAccelerationX	= 4.0;	refship.InertiaBrakingX		= 3.5;
	refship.InertiaAccelerationY	= 3.0;	refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale	= 0.8;
	refShip.GeraldSails.rey_b2.vscale	= 0.65;
	refShip.GeraldSails.rey_b3.vscale	= 0.55;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.25;
	refship.Track1.LifeTime 	= 9.5;
	refship.Track1.Width		= "7.0, 7.5";
	refship.Track1.Speed		= "8.0, 9.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 7.5;
	refship.Track2.Width		= "8.0, 10.0";
	refship.Track2.Speed		= "1.0, 2.0";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //
	
	///////////////////////////////////////////////////////////////////////////
	/// Couronne - La Couronne
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_COURONNE]);
	refShip.Name            			= "Couronne";
	refship.Soundtype			= "lineship";
	refShip.Class			= 2;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 36;
	refShip.Weight				= Tonnes2CWT(3000);
	refShip.Capacity        			= 5700;
	refShip.CannonsQuantity		= 64;
	refShip.rcannon 						= 24;
	refShip.lcannon 						= 24;
	refShip.fcannon 						= 8;
	refShip.bcannon 						= 8;
	refShip.MaxCrew         	= 560;
	refShip.MinCrew         		= 28;
	refShip.BoardingCrew		= 340;
	refShip.GunnerCrew			= 64;
	refShip.CannonerCrew			= 128;
	refShip.SailorCrew		= 550;
	refShip.SpeedRate		= 10.5;
	refShip.TurnRate        	= 8.0;
	refShip.Price           	= 250000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              	= 15800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 14800;
}
	refShip.SP              	= 400;
	refShip.AbordageLocation		= "Boarding Deck_01";
	refship.Type.Merchant				= false;
	refship.Type.War				= true;
	refShip.fWindAgainstSpeed	= 1.4;
	refShip.sea_enchantment		= 1.1;
	refShip.lowpolycrew 		= 24;
	refShip.buildtime 		= 120;

	refship.Rocking.y 		= 0.5;
	refship.Rocking.az 		= 0.035;
	
	
	refship.WaterLine		= 0.1;
	refship.SpeedDependWeight	= 0.35;
	refship.SubSeaDependWeight	= 0.75;
	refship.TurnDependWeight	= 0.4;
	refship.WindAgainstSpeed   	= 1.0;//boal
	refship.CabinType          	= "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           	= "Big";
	
	refship.InertiaAccelerationX	= 3.5;	refship.InertiaBrakingX		= 3.0;
	refship.InertiaAccelerationY	= 2.5;	refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 3.5;	refship.InertiaBrakingZ		= 3.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale	= 0.7;
	refShip.GeraldSails.rey_b2.vscale	= 0.65;
	refShip.GeraldSails.rey_b3.vscale	= 0.65;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.25;
	refship.Track1.LifeTime 	= 16.5;
	refship.Track1.Width		= "6.0, 8.2";
	refship.Track1.Speed		= "9.0, 9.0";

	refship.Track2.ZStart		= 0.0;
	refship.Track2.LifeTime 	= 13.5;
	refship.Track2.Width		= "8.0, 9.0";
	refship.Track2.Speed		= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	// Superior Warship
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_FR_SUPERIORWARSHIP1]);
	refShip.Name            			= "FR_SuperiorWarship1";
	refship.Soundtype			= "lineship";
	refShip.Class			= 2;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 42;
	refShip.Weight			= Tonnes2CWT(3200);
	refShip.Capacity        			= 5600;
	refShip.CannonsQuantity		= 74;
	refShip.rcannon 						= 34;
	refShip.lcannon 						= 34;
	refShip.fcannon 						= 2;
	refShip.bcannon 						= 4;
	refShip.MaxCrew         			= 660;
	refShip.MinCrew         			= 30;
	refShip.BoardingCrew					= 408;
	refShip.GunnerCrew				= 74;
	refShip.CannonerCrew				= 148;
	refShip.SailorCrew				= 650;
	refShip.SpeedRate					= 10.7;
	refShip.TurnRate        			= 8.5;
	refShip.Price           			= 430000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 15800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 14800;
}
	refShip.SP              			= 450;
	refShip.AbordageLocation			= "Boarding Deck_03";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.4;
	refShip.sea_enchantment					= 1.1;
	refShip.lowpolycrew = 24;
	refShip.buildtime = 120;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine = 0.30;
	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 0.55;
	refship.TurnDependWeight = 0.8;
	refship.WindAgainstSpeed   = 1.0;//boal
	refship.CabinType          = "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           = "Big";

	refShip.Height.Bombs.Y				= 4.0;		refShip.Height.Bombs.DY		= 2.0;
	refShip.Height.Grapes.Y				= 7.0;		refShip.Height.Grapes.DY	= 1.5;
	refShip.Height.Knippels.Y			= 36.0;		refShip.Height.Knippels.DY	= 32.0;
	refShip.Height.Balls.Y				= 4.0;		refShip.Height.Balls.DY		= 2.0;
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 7;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 1.0;

	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.65;
	refShip.GeraldSails.rey_b3.vscale		= 0.65;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.25;
	refship.Track1.LifeTime = 16.5;
	refship.Track1.Width	= "6.0, 8.2";
	refship.Track1.Speed	= "9.0, 9.0";

	refship.Track2.ZStart	= 0.0;
	refship.Track2.LifeTime = 13.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Warship - Le Superbe
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SUPERBE]);
	refShip.Name            		= "Superbe";  
	refship.Soundtype		= "lineship";
	refShip.Class			= 2;
	refShip.Cannon          		= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      		= 42;
	refShip.Weight			= Tonnes2CWT(2500);
	refShip.Capacity        		= 5200;
	refShip.CannonsQuantity		= 78;
	refShip.rcannon 			= 37;
	refShip.lcannon 			= 37;
	refShip.fcannon 			= 2;
	refShip.bcannon 			= 2;
	refShip.MaxCrew         		= 650;
	refShip.MinCrew         		= 30;
	refShip.BoardingCrew		= 379;
	refShip.GunnerCrew		= 78;
	refShip.CannonerCrew		= 156;
	refShip.SailorCrew		= 366;
	refShip.SpeedRate		= 9.5;
	refShip.TurnRate        		= 8.5;
	refShip.Price           		= 450000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              		= 16900;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 15900;
}
	refShip.SP              		= 450;
	refShip.AbordageLocation	= "Boarding Deck_01";
	refship.Type.Merchant		= false;
	refship.Type.War			= true;
	refShip.fWindAgainstSpeed	= 1.4;
	refShip.sea_enchantment		= 1.1;
	refShip.lowpolycrew 		= 24;
	refShip.buildtime 			= 120;

	refship.Rocking.y 		= 0.5;
	refship.Rocking.az 		= 0.035;
	
	refship.WaterLine			= -0.1;

	refship.SpeedDependWeight	= 0.35;
	refship.SubSeaDependWeight	= 1.0;
	refship.TurnDependWeight	= 0.4;
	refship.WindAgainstSpeed   	= 1.0;//boal
	refship.CabinType          		= "Cabin"; // boal 28.03.05
	refship.DeckType           		= "Big";
	
	refship.InertiaAccelerationX	= 4.0;	refship.InertiaBrakingX		= 3.5;
	refship.InertiaAccelerationY	= 3.0;	refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.5;
	
	refShip.GeraldSails.rey_b2	= 1;
	refShip.GeraldSails.rey_b3	= 1;
	refShip.GeraldSails.rey_b1	= 1;
	refShip.GeraldSails.rey_b1.vscale	= 0.8;
	refShip.GeraldSails.rey_b2.vscale	= 0.65;
	refShip.GeraldSails.rey_b3.vscale	= 0.55;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.25;
	refship.Track1.LifeTime 		= 9.5;
	refship.Track1.Width		= "7.0, 7.5";
	refship.Track1.Speed		= "8.0, 9.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 		= 7.5;
	refship.Track2.Width		= "8.0, 10.0";
	refship.Track2.Speed		= "1.0, 2.0";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Link - 2nd Rate Ship of the line
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_LINK]);
	refShip.Name            			= "Link";
	refship.Soundtype					= "manowar";
	refShip.Class						= 2;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 32;
	refShip.Weight						= Tonnes2CWT(3500);
	refShip.Capacity        			= 5600;
	refShip.CannonsQuantity				= 78;
	refShip.rcannon 					= 37;
	refShip.lcannon 					= 37;
	refShip.fcannon 					= 2;
	refShip.bcannon 					= 2;
	refShip.MaxCrew         			= 640;
	refShip.MinCrew         			= 26;
	refShip.BoardingCrew				= 368;
	refShip.GunnerCrew					= 82;
	refShip.CannonerCrew				= 164;
	refShip.SailorCrew					= 630;
	refShip.SpeedRate					= 10.3;
	refShip.TurnRate        			= 8.1;
	refShip.Price           			= 550000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 16500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 15500;
}
	refShip.SP              			= 450;;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.0;
	refShip.sea_enchantment					= 1.0;
	refShip.lowpolycrew = 28;
	refShip.buildtime = 140;

	refship.Rocking.y = 0.3;
	refship.Rocking.az = 0.02	;

	refship.WaterLine							= -0.2;
	refship.SpeedDependWeight			= 0.45;
	refship.SubSeaDependWeight			= 1.8;
	refship.TurnDependWeight			= 0.45;
	refship.WindAgainstSpeed   = 1.0;//boal
	refship.CabinType          = "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 1.5;	refship.InertiaBrakingX		= 1.5;
	refship.InertiaAccelerationY	= 1.5;	refship.InertiaBrakingY		= 1.5;
	refship.InertiaAccelerationZ	= 1.5;	refship.InertiaBrakingZ		= 1.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_c1		= 1;
	refShip.GeraldSails.rey_c1.vscale		= 0.98;
	refShip.GeraldSails.rey_b2.vscale		= 0.98;
	refShip.GeraldSails.rey_b3.vscale		= 0.98;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.30;
	refship.Track1.LifeTime = 18.5;
	refship.Track1.Width	= "6.5, 7.5";
	refship.Track1.Speed	= "8.0, 9.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 10.5;
	refship.Track2.Width	= "16.0, 18.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //


///////////////////////////////////////////////////////////////////////////
//class 1
///////////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////
	/// Battleship 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BATTLESHIP]);
	refShip.Name            			= "Battleship";
	refship.Soundtype			= "lineship";
	refShip.Class			= 1;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 42;
	refShip.Weight			= Tonnes2CWT(3000);
	refShip.Capacity        			= 5400;
	refShip.CannonsQuantity		= 80;
	refShip.rcannon 							= 36;
	refShip.lcannon 							= 36;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 6;
	refShip.MaxCrew         		= 590;
	refShip.MinCrew         		= 30;
	refShip.BoardingCrew						= 320;
	refShip.GunnerCrew				= 80;
	refShip.CannonerCrew				= 160;
	refShip.SailorCrew					= 680;
	refShip.SpeedRate					= 10.9;
	refShip.TurnRate        			= 8.0;
	refShip.Price           			= 380000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 16800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 15800;
}
	refShip.SP              			= 450;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.4;
	refShip.sea_enchantment					= 1.1;
	refShip.lowpolycrew = 24;
	refShip.buildtime = 120;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	
	refship.WaterLine							= 0.30;
	refship.SpeedDependWeight			= 0.35;
	refship.SubSeaDependWeight			= 0.75;
	refship.TurnDependWeight			= 0.4;
	refship.WindAgainstSpeed   = 1.0;//boal
	refship.CabinType          = "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 3.5;	refship.InertiaBrakingX		= 3.0;
	refship.InertiaAccelerationY	= 2.5;	refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 3.5;	refship.InertiaBrakingZ		= 3.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.7;
	refShip.GeraldSails.rey_b2.vscale		= 0.65;
	refShip.GeraldSails.rey_b3.vscale		= 0.65;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.25;
	refship.Track1.LifeTime = 16.5;
	refship.Track1.Width	= "6.0, 8.2";
	refship.Track1.Speed	= "9.0, 9.0";

	refship.Track2.ZStart	= 0.0;
	refship.Track2.LifeTime = 13.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Warship Bellona
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BELLONA]);
	refShip.Name            			= "Bellona";
	refship.Soundtype			= "lineship";
	refShip.Class			= 1;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 42;
	refShip.Weight			= Tonnes2CWT(2500);
	refShip.Capacity        			= 5400;
	refShip.CannonsQuantity		= 84;
	refShip.rcannon 				= 40;
	refShip.lcannon 				= 40;
	refShip.fcannon 				= 2;
	refShip.bcannon 				= 2;
	refShip.MaxCrew         		= 590;
	refShip.MinCrew         		= 37;
	refShip.BoardingCrew					= 301;
	refShip.GunnerCrew				= 84;
	refShip.CannonerCrew				= 168;
	refShip.SailorCrew					= 680;
	refShip.SpeedRate			= 11.0;
	refShip.TurnRate        			= 7.2;
	refShip.Price           			= 420000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 15900;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 14900;
}
	refShip.SP              			= 450;
	refShip.AbordageLocation	= "Boarding Deck_01";
	refship.Type.Merchant		= false;
	refship.Type.War		= true;
	refShip.fWindAgainstSpeed	= 1.4;
	refShip.sea_enchantment		= 1.1;
	refShip.lowpolycrew 		= 24;
	refShip.buildtime 		= 120;

	refship.Rocking.y 		= 0.5;
	refship.Rocking.az 		= 0.035;
	
	refship.WaterLine		= 0.5;

	refship.SpeedDependWeight	= 0.35;
	refship.SubSeaDependWeight	= 1.0;
	refship.TurnDependWeight	= 0.4;
	refship.WindAgainstSpeed   	= 1.0;//boal
	refship.CabinType          	= "Cabin"; // boal 28.03.05
	refship.DeckType           	= "Big";
	
	refship.InertiaAccelerationX	= 4.0;	refship.InertiaBrakingX		= 3.5;
	refship.InertiaAccelerationY	= 3.0;	refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale	= 0.8;
	refShip.GeraldSails.rey_b2.vscale	= 0.65;
	refShip.GeraldSails.rey_b3.vscale	= 0.55;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.25;
	refship.Track1.LifeTime 	= 9.5;
	refship.Track1.Width		= "7.0, 7.5";
	refship.Track1.Speed		= "8.0, 9.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 	= 7.5;
	refship.Track2.Width		= "8.0, 10.0";
	refship.Track2.Speed		= "1.0, 2.0";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Neptune
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_NEPTUNE]);
	refShip.Name            		= "Neptune";  
	refship.Soundtype		= "lineship";
	refShip.Class			= 1;
	refShip.Cannon          		= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      		= 32;
	refShip.Weight			= Tonnes2CWT(2500);
	refShip.Capacity        		= 5200;
	refShip.CannonsQuantity		= 82;
	refShip.rcannon 			= 37;
	refShip.lcannon 			= 37;
	refShip.fcannon 			= 2;
	refShip.bcannon 			= 6;
	refShip.MaxCrew         		= 730;
	refShip.MinCrew         		= 30;
	refShip.BoardingCrew		= 454;
	refShip.GunnerCrew		= 82;
	refShip.CannonerCrew		= 164;
	refShip.SailorCrew		= 446;
	refShip.SpeedRate		= 11.7;
	refShip.TurnRate        		= 7.0;
	refShip.Price           		= 465000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              		= 17000;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 16000;
}
	refShip.SP              		= 450;
	refShip.AbordageLocation	= "Boarding Deck_01";
	refship.Type.Merchant		= false;
	refship.Type.War			= true;
	refShip.fWindAgainstSpeed	= 1.4;
	refShip.sea_enchantment		= 1.1;
	refShip.lowpolycrew 		= 24;
	refShip.buildtime 			= 120;

	refship.Rocking.y 		= 0.5;
	refship.Rocking.az 		= 0.035;
	
	refship.WaterLine			= 0.2;

	refship.SpeedDependWeight	= 0.35;
	refship.SubSeaDependWeight	= 1.0;
	refship.TurnDependWeight	= 0.4;
	refship.WindAgainstSpeed   	= 1.0;//boal
	refship.CabinType          		= "Cabin"; // boal 28.03.05
	refship.DeckType           		= "Big";
	
	refship.InertiaAccelerationX	= 4.0;	refship.InertiaBrakingX		= 3.5;
	refship.InertiaAccelerationY	= 3.0;	refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.5;
	
	refShip.GeraldSails.rey_b2	= 1;
	refShip.GeraldSails.rey_b3	= 1;
	refShip.GeraldSails.rey_b1	= 1;
	refShip.GeraldSails.rey_b1.vscale	= 0.8;
	refShip.GeraldSails.rey_b2.vscale	= 0.65;
	refShip.GeraldSails.rey_b3.vscale	= 0.55;

	refship.Track.Enable		= true;
	refship.Track1.ZStart		= 0.25;
	refship.Track1.LifeTime 		= 9.5;
	refship.Track1.Width		= "7.0, 7.5";
	refship.Track1.Speed		= "8.0, 9.0";

	refship.Track2.ZStart		= -0.15;
	refship.Track2.LifeTime 		= 7.5;
	refship.Track2.Width		= "8.0, 10.0";
	refship.Track2.Speed		= "1.0, 2.0";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Manowar
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_MANOWAR]);
	refShip.Name            			= "Manowar";
	refship.Soundtype			= "manowar";
	refShip.Class			= 1;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 48;
	refShip.Weight			= Tonnes2CWT(4000);
	refShip.Capacity        			= 6200;
	refShip.CannonsQuantity		= 102;
	refShip.rcannon 							= 45;
	refShip.lcannon 							= 45;
	refShip.fcannon 							= 4;
	refShip.bcannon 							= 8;
	refShip.MaxCrew         			= 860;
	refShip.MinCrew         			= 30;
	refShip.BoardingCrew						= 524;
	refShip.GunnerCrew							= 102;
	refShip.CannonerCrew				= 204;
	refShip.SailorCrew					= 850;
	refShip.SpeedRate					= 8.5;
	refShip.TurnRate        			= 6.5;
	refShip.Price           			= 500000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 19500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 18500;
}
	refShip.SP              			= 500;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.0;
	refShip.sea_enchantment					= 1.0;
	refShip.lowpolycrew = 28;
	refShip.buildtime = 140;

	refship.Rocking.y = 0.3;
	refship.Rocking.az = 0.02	;

	refship.WaterLine							= 0.5;
	refship.SpeedDependWeight			= 0.45;
	refship.SubSeaDependWeight			= 1.8;
	refship.TurnDependWeight			= 0.45;
	refship.WindAgainstSpeed   = 0.7;//boal
	refship.CabinType          = "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 1.5;	refship.InertiaBrakingX		= 1.5;
	refship.InertiaAccelerationY	= 1.5;	refship.InertiaBrakingY		= 1.5;
	refship.InertiaAccelerationZ	= 1.5;	refship.InertiaBrakingZ		= 1.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_c1		= 1;
	refShip.GeraldSails.rey_c1.vscale		= 0.98;
	refShip.GeraldSails.rey_b2.vscale		= 0.98;
	refShip.GeraldSails.rey_b3.vscale		= 0.98;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.30;
	refship.Track1.LifeTime = 18.5;
	refship.Track1.Width	= "6.5, 7.5";
	refship.Track1.Speed	= "8.0, 9.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 10.5;
	refship.Track2.Width	= "16.0, 18.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	/// HMS_Victory - Victory
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_HMS_VICTORY]);
	refShip.Name            			= "HMS_Victory";
	refship.Soundtype			= "manowar";
	refShip.Class			= 1;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 48;
	refShip.Weight			= Tonnes2CWT(4000);
	refShip.Capacity        			= 6700;
	refShip.CannonsQuantity				= 104;
	refShip.rcannon 							= 50;
	refShip.lcannon 							= 50;
	refShip.fcannon 							= 2;
	refShip.bcannon 							= 2;
	refShip.MaxCrew         			= 880;
	refShip.MinCrew         			= 30;
	refShip.BoardingCrew						= 532;
	refShip.GunnerCrew							= 104;
	refShip.CannonerCrew				= 208;
	refShip.SailorCrew					= 870;
	refShip.SpeedRate					= 8.8;
	refShip.TurnRate        			= 6.2;
	refShip.Price           			= 570000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 19500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 18500;
}
	refShip.SP              			= 500;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.0;
	refShip.sea_enchantment					= 1.0;
	refShip.lowpolycrew = 28;
	refShip.buildtime = 140;

	refship.Rocking.y = 0.3;
	refship.Rocking.az = 0.02;

	refship.WaterLine							= 0.5;
	refship.SpeedDependWeight			= 0.45;
	refship.SubSeaDependWeight			= 1.8;
	refship.TurnDependWeight			= 0.45;
	refship.WindAgainstSpeed   = 0.7;//boal
	refship.CabinType          = "Cabin_Victory"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 1.5;	refship.InertiaBrakingX		= 1.5;
	refship.InertiaAccelerationY	= 1.5;	refship.InertiaBrakingY		= 1.5;
	refship.InertiaAccelerationZ	= 1.5;	refship.InertiaBrakingZ		= 1.5;
	
	refShip.GeraldSails.rey_b2			= 1;
	refShip.GeraldSails.rey_b3			= 1;
	refShip.GeraldSails.rey_c1			= 1;
	refShip.GeraldSails.rey_c1.vscale		= 0.98;
	refShip.GeraldSails.rey_b2.vscale		= 0.98;
	refShip.GeraldSails.rey_b3.vscale		= 0.98;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.30;
	refship.Track1.LifeTime = 18.5;
	refship.Track1.Width	= "6.5, 7.5";
	refship.Track1.Speed	= "8.0, 9.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 10.5;
	refship.Track2.Width	= "16.0, 18.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 0.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 0.0; //

	///////////////////////////////////////////////////////////////////////////
	// Battle Manowar
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BATTLEMANOWAR]);
	refShip.Name            			= "BattleManowar";
	refship.Soundtype			= "manowar";
	refShip.Class			= 1;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS4;
	refShip.MaxCaliber      			= 48;
	refShip.Weight			= Tonnes2CWT(4100);
	refShip.Capacity        			= 6700;
	refShip.CannonsQuantity				= 102;
	refShip.rcannon 					= 46;
	refShip.lcannon 					= 46;
	refShip.fcannon 					= 2;
	refShip.bcannon 					= 8;
	refShip.MaxCrew         			= 924;
	refShip.MinCrew         			= 30;
	refShip.BoardingCrew					= 588;
	refShip.GunnerCrew				= 102;
	refShip.CannonerCrew				= 204;
	refShip.SailorCrew				= 910;
	refShip.SpeedRate					= 8.0;
	refShip.TurnRate        			= 6.0;
	refShip.Price           			= 570000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 20000;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 19000;
}
	refShip.SP              			= 500;
	refShip.AbordageLocation			= "Boarding Deck_03";
	refship.Type.Merchant					= false;
	refship.Type.War					= true;
	refShip.fWindAgainstSpeed				= 1.0;
	refShip.sea_enchantment					= 1.0;
	refShip.lowpolycrew = 28;
	refShip.buildtime = 140;

	refship.Rocking.y = 0.3;
	refship.Rocking.az = 0.02;

	refship.WaterLine = 0.0;
	refship.SpeedDependWeight = 0.3;
	refship.SubSeaDependWeight = 0.9;
	refship.TurnDependWeight = 0.8;
	refship.WindAgainstSpeed   = 0.7;//boal
	refship.CabinType          = "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           = "Big";

	refShip.Height.Bombs.Y				= 6.7;		refShip.Height.Bombs.DY		= 3.0;
	refShip.Height.Grapes.Y				= 11.0;		refShip.Height.Grapes.DY	= 3.0;
	refShip.Height.Knippels.Y			= 46.0;		refShip.Height.Knippels.DY	= 40.0;
	refShip.Height.Balls.Y				= 6.7;		refShip.Height.Balls.DY		= 3.0;
	
	refship.InertiaAccelerationX	= 0.2;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 3;
	refship.InertiaAccelerationZ	= 3.0;	refship.InertiaBrakingZ		= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.98;
	refShip.GeraldSails.rey_b3.vscale		= 0.98;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.30;
	refship.Track1.LifeTime = 18.5;
	refship.Track1.Width	= "6.5, 7.5";
	refship.Track1.Speed	= "8.0, 9.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 10.5;
	refship.Track2.Width	= "16.0, 18.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

//quest ships

	///////////////////////////////////////////////////////////////////////////
	///  
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_SOLEYRU]);
	refShip.Name            			= "SoleyRu";
	refship.Soundtype			= "manowar";
	refShip.Class 				= 1;
	refShip.Cannon 				= CANNON_TYPE_CANNON_LBS48;
	refShip.MaxCaliber 				= 48;
	refShip.Weight 				= Tonnes2CWT(4500);
	refShip.Capacity 				= 7000;
	refShip.CannonsQuantity				= 112;
	refShip.rcannon 							= 48;
	refShip.lcannon 							= 48;
	refShip.fcannon 							= 6;
	refShip.bcannon 							= 10;
	refShip.MaxCrew 			= 1200;
	refShip.MinCrew 			= 36;
	refShip.BoardingCrew 				= 828;
	refShip.GunnerCrew 				= 112;
	refShip.CannonerCrew 					= 224;
	refShip.SailorCrew 				= 1190;
	refShip.SpeedRate 					= 9.6;
	refShip.TurnRate 				= 10.0;
	refShip.Price 					= 650000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP 					= 20700;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 19700;
}
	refShip.SP 					= 500;
	refship.EmblemedSails.normalTex = "ships\parus_SoleyRu.tga";
	refShip.AbordageLocation			= "Boarding Deck_01";

	refship.CanEncounter = false;
	
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 1.0;
	refShip.sea_enchantment					= 1.0;
	refShip.lowpolycrew = 28;
	refShip.buildtime = 140;

	refship.Rocking.y = 0.3;
	refship.Rocking.az = 0.02;

	refship.WaterLine							= 0.5;
	refship.SpeedDependWeight			= 0.45;
	refship.SubSeaDependWeight			= 1.8;
	refship.TurnDependWeight			= 0.45;
	refship.WindAgainstSpeed   = 1.3;//boal
	refship.CabinType          = "Cabin_Huge"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 2.0;	refship.InertiaBrakingX		= 2.0;
	refship.InertiaAccelerationY	= 2;	refship.InertiaBrakingY		= 2;
	refship.InertiaAccelerationZ	= 2.0;	refship.InertiaBrakingZ		= 2.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_c1		= 1;
	refShip.GeraldSails.rey_c1.vscale		= 0.98;
	refShip.GeraldSails.rey_b2.vscale		= 0.98;
	refShip.GeraldSails.rey_b3.vscale		= 0.98;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.30;
	refship.Track1.LifeTime = 18.5;
	refship.Track1.Width	= "6.5, 7.5";
	refship.Track1.Speed	= "8.0, 9.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 10.5;
	refship.Track2.Width	= "16.0, 18.0";

	//Nation
        refShip.england = 0.0; //
        refShip.france = 1.0; //
        refShip.holland = 0.0; //
        refShip.pirate = 0.0; //
        refShip.spain = 1.0; //

	//////////////////////////////////////////////////////////////////////////
	// BrigQeen
	//////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BRIGQEEN]);
	refShip.Name			= "BrigQeen";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon  			= CANNON_TYPE_CULVERINE_LBS16;
	refShip.MaxCaliber 			 = 20;
	refShip.Weight			= Tonnes2CWT(400);
	refShip.Capacity   			= 2500;
	refShip.CannonsQuantity		= 24;
	refShip.rcannon 				= 10;
	refShip.lcannon 				= 10;
	refShip.fcannon 				= 2;
	refShip.bcannon 				= 2;
	refShip.MaxCrew        		= 130;
	refShip.MinCrew        		= 12;
	refShip.BoardingCrew		= 46;
	refShip.GunnerCrew			= 24;
	refShip.CannonerCrew		= 48;
	refShip.SailorCrew			= 130;
	refShip.SpeedRate      		= 15.0;
	refShip.TurnRate       		= 15.0;
	refShip.Price          		= 67500;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP             		= 5500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 4500;
}
	refShip.SP             		= 350;
	refShip.AbordageLocation	= "Boarding Deck_02";
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	refship.Type.Merchant		= false;
	refship.Type.War			= true;
	refShip.fWindAgainstSpeed	= 4.3;
	refShip.sea_enchantment		= 1.8;
	refShip.lowpolycrew			= 12;
	refShip.buildtime			= 60;

	refship.WindAgainstSpeed   = 4.5;//boal

	refship.Rocking.y	= 0.5;
	refship.Rocking.az	= 0.04;
	
	refship.WaterLine	= 0.50;
	refship.SpeedDependWeight		= 0.3;
	refship.SubSeaDependWeight		= 0.6;
	refship.TurnDependWeight		= 0.3;
	
	refship.InertiaAccelerationX	= 5.5;	refship.InertiaBrakingX	= 5.5;
	refship.InertiaAccelerationY	= 8;	refship.InertiaBrakingY	= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ	= 6.0;

	refShip.Height.Bombs.Y	= 1.0;			refShip.Height.Bombs.DY	= 1.0;
	refShip.Height.Grapes.Y	= 2.0;			refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y	= 16.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y		= 1.0;		refShip.Height.Balls.DY	= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale	= 0.8;
	refShip.GeraldSails.rey_b3.vscale	= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//////////////////////////////////////////////////////////////////////////
	// BrigSW
	//////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_BRIGSW]);
	refShip.Name			= "BrigSW";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon  			= CANNON_TYPE_CANNON_LBS16;
	refShip.MaxCaliber 			 = 20;
	refShip.Weight			= Tonnes2CWT(400);
	refShip.Capacity   			= 2500;
	refShip.CannonsQuantity		= 24;
	refShip.rcannon 				= 10;
	refShip.lcannon 				= 10;
	refShip.fcannon 				= 2;
	refShip.bcannon 				= 2;
	refShip.MaxCrew        			= 130;
	refShip.MinCrew        			= 12;
	refShip.BoardingCrew		= 46;
	refShip.GunnerCrew			= 24;
	refShip.CannonerCrew		= 48;
	refShip.SailorCrew			= 130;
	refShip.SpeedRate      		= 15.5;
	refShip.TurnRate       		= 15.0;
	refShip.Price          		= 70500;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP             		= 5500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 4500;
}
	refShip.SP             		= 350;
	refShip.AbordageLocation	= "Boarding Deck_02";
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	refship.Type.Merchant		= false;
	refship.Type.War			= true;
	refShip.fWindAgainstSpeed	= 4.5;
	refShip.sea_enchantment		= 1.8;
	refShip.lowpolycrew			= 12;
	refShip.buildtime			= 60;

	refship.WindAgainstSpeed   = 4.2;//boal

	refship.Rocking.y	= 0.5;
	refship.Rocking.az	= 0.04;
	
	refship.WaterLine	= 0.50;
	refship.SpeedDependWeight		= 0.3;
	refship.SubSeaDependWeight		= 0.6;
	refship.TurnDependWeight		= 0.3;
	
	refship.InertiaAccelerationX	= 5.5;	refship.InertiaBrakingX	= 5.5;
	refship.InertiaAccelerationY	= 8;	refship.InertiaBrakingY	= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ	= 6.0;

	refShip.Height.Bombs.Y	= 1.0;			refShip.Height.Bombs.DY	= 1.0;
	refShip.Height.Grapes.Y	= 2.0;			refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y	= 16.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y		= 1.0;		refShip.Height.Balls.DY	= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale	= 0.8;
	refShip.GeraldSails.rey_b3.vscale	= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//////////////////////////////////////////////////////////////////////////
	// 
	//////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_XebekVML]);
	refShip.Name			= "XebekVML";
	refship.Soundtype			= "lugger";
	refShip.Class			= 5;
	refShip.Cannon  			= CANNON_TYPE_CULVERINE_LBS12;
	refShip.MaxCaliber  			= 12;
	refShip.Weight			= Tonnes2CWT(400);
	refShip.Capacity   			= 2000;
	refShip.CannonsQuantity		= 22;
	refShip.rcannon 				= 9;
	refShip.lcannon 				= 9;
	refShip.fcannon 				= 2;
	refShip.bcannon 				= 2;
	refShip.MaxCrew        			= 118;
	refShip.MinCrew        			= 10;
	refShip.BoardingCrew		= 42;
	refShip.GunnerCrew			= 22;
	refShip.CannonerCrew		= 44;
	refShip.SailorCrew			= 114;
	refShip.SpeedRate      		= 15.5;
	refShip.TurnRate       		= 14.0;
	refShip.Price          		= 150500;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP             		= 4800;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 3800;
}
	refShip.SP             		= 400;
	refShip.AbordageLocation	= "Boarding Deck_02";
	refship.CabinType          = "Cabin_Small"; // boal 28.03.05
	refship.Type.Merchant		= false;
	refship.Type.War			= true;
	refShip.fWindAgainstSpeed	= 11.0;
	refShip.sea_enchantment		= 1.8;
	refShip.lowpolycrew			= 12;
	refShip.buildtime			= 60;

	refship.WindAgainstSpeed   = 10.0;//boal

	refship.Rocking.y	= 0.5;
	refship.Rocking.az	= 0.04;
	
	refship.WaterLine	= 0.60;
	refship.SpeedDependWeight		= 0.3;
	refship.SubSeaDependWeight		= 0.90;
	refship.TurnDependWeight		= 0.3;
	
	refship.InertiaAccelerationX	= 5.5;	refship.InertiaBrakingX	= 5.5;
	refship.InertiaAccelerationY	= 8;	refship.InertiaBrakingY	= 8;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ	= 6.0;

	refShip.Height.Bombs.Y	= 1.0;			refShip.Height.Bombs.DY	= 1.0;
	refShip.Height.Grapes.Y	= 2.0;			refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y	= 16.0;		refShip.Height.Knippels.DY	= 10.0;
	refShip.Height.Balls.Y		= 1.0;		refShip.Height.Balls.DY	= 1.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale	= 0.8;
	refShip.GeraldSails.rey_b3.vscale	= 0.8;
	
	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 12;
	refship.Track1.Width	= "2.0, 3.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "4.0, 6.0";
	refship.Track2.Speed	= "0.15, 0.25";

	///////////////////////////////////////////////////////////////////////////
	/// Corvette 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_CORVETTE_QUEST]);
	refShip.Name            			= "Corvette_quest";
	refship.Soundtype			= "corvette";
	refShip.Class			= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS20;
	refShip.MaxCaliber      			= 20;
	refShip.Weight			= Tonnes2CWT(680);
	refShip.Capacity        			= 4000;
	refShip.CannonsQuantity				= 40;
	refShip.rcannon 					= 16;
	refShip.lcannon 					= 16;
	refShip.fcannon 					= 4;
	refShip.bcannon 					= 4;
	refShip.MaxCrew         		= 240;
	refShip.MinCrew         		= 20;
	refShip.BoardingCrew			= 100;
	refShip.GunnerCrew				= 40;
	refShip.CannonerCrew			= 80;
	refShip.SailorCrew				= 240;
	refShip.SpeedRate					= 20.0;
	refShip.TurnRate        			= 14.0;
	refShip.Price           			= 150000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 7700;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 6700;
}
	refShip.SP              			= 450;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 5.2;
	refShip.sea_enchantment					= 1.5;
	refShip.lowpolycrew = 16;
	refShip.buildtime = 80;

	refship.Rocking.y = 0.8;
	refship.Rocking.az = 0.025;
	
	refship.WaterLine					= 0.22;
	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 0.42;
	refship.TurnDependWeight			= 0.35;
	refship.WindAgainstSpeed   = 6.0;//boal
	refship.CabinType          = "Cabin_Medium"; // boal 28.03.05
	
	refship.InertiaAccelerationX	= 8.0;	refship.InertiaBrakingX		= 8.0;
	refship.InertiaAccelerationY	= 6;	refship.InertiaBrakingY		= 6;
	refship.InertiaAccelerationZ	= 6.0;	refship.InertiaBrakingZ		= 6.0;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.17;
	refship.Track1.LifeTime = 12.5;
	refship.Track1.Width	= "4.0, 5.0";
	refship.Track1.Speed	= "6.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 6.5;
	refship.Track2.Width	= "5.0, 7.0";
	refship.Track2.Speed	= "0.15, 0.25";

	///////////////////////////////////////////////////////////////////////////
	/// Frigate Arabella
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_ARABELLA]);
	refShip.Name            			= "ArabellaShip";
	refship.Soundtype			= "frigate";
	refShip.Class			= 3;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS20;
	refShip.MaxCaliber      			= 24;
	refShip.Weight			= Tonnes2CWT(1000);
	refShip.Capacity        			= 5400;
	refShip.CannonsQuantity				= 52;
	refShip.rcannon 							= 22;
	refShip.lcannon 							= 22;
	refShip.fcannon 							= 4;
	refShip.bcannon 							= 4;
	refShip.MaxCrew         			= 300;
	refShip.MinCrew         			= 22;
	refShip.BoardingCrew						= 122;
	refShip.GunnerCrew							= 52;
	refShip.CannonerCrew				= 104;
	refShip.SailorCrew					= 300;
	refShip.SpeedRate       			= 15.4;
	refShip.TurnRate        			= 12.0;
	refShip.Price           			= 250000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 7650;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 8650;
}
	refShip.SP              			= 500;
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 4.0;
	refShip.sea_enchantment					= 1.2;
	refShip.lowpolycrew = 20;
	refShip.buildtime = 100;
	
	refship.Rocking.y = 0.4;
	refship.Rocking.az = 0.035;	
	refship.WaterLine							= 0.0;

	refship.SpeedDependWeight			= 0.3;
	refship.SubSeaDependWeight			= 0.29;
	refship.TurnDependWeight			= 0.3;
	refship.WindAgainstSpeed   = 4.5;//boal
	refship.CabinType          = "Cabin"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 5.0;	refship.InertiaBrakingX		= 5.0;
	refship.InertiaAccelerationY	= 4;	refship.InertiaBrakingY		= 4;
	refship.InertiaAccelerationZ	= 5.0;	refship.InertiaBrakingZ		= 5.0;
	
	refShip.Height.Bombs.Y				= 1.0;	refShip.Height.Bombs.DY		= 0.5;
	refShip.Height.Grapes.Y				= 2.0;	refShip.Height.Grapes.DY	= 1.0;
	refShip.Height.Knippels.Y			= 10.0;	refShip.Height.Knippels.DY	= 8.0;
	refShip.Height.Balls.Y				= 1.0;	refShip.Height.Balls.DY		= 0.5;
	
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.9;
	refShip.GeraldSails.rey_b2.vscale		= 0.7;
	refShip.GeraldSails.rey_b3.vscale		= 0.7;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.20;
	refship.Track1.LifeTime = 14.5;
	refship.Track1.Width	= "3.7, 3.9";
	refship.Track1.Speed	= "7.0, 8.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 8.5;
	refship.Track2.Width	= "8.0, 9.0";
	refship.Track2.Speed	= "0.15, 0.25";

	//Nation
        refShip.england = 1.0; //
        refShip.france = 1.0; //
        refShip.holland = 1.0; //
        refShip.pirate = 1.0; //
        refShip.spain = 1.0; //

	///////////////////////////////////////////////////////////////////////////
	/// Flyingdutchman 
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_FLYINGDUTCHMAN]);
	refShip.Name            			= "Flyingdutchman";  // 
	refship.Soundtype			= "lineship";
	refShip.Class			= 2;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS48;
	refShip.MaxCaliber      			= 48;
	refShip.Weight			= Tonnes2CWT(2500);
	refShip.Capacity        			= 5800;
	refShip.CannonsQuantity						= 60;
	refShip.rcannon 							= 24;
	refShip.lcannon 							= 24;
	refShip.fcannon 							= 4;
	refShip.bcannon 							= 8;
	refShip.MaxCrew         			= 840;
	refShip.MinCrew         			= 30;
	refShip.BoardingCrew						= 630;
	refShip.GunnerCrew							= 60;
	refShip.CannonerCrew				= 120;
	refShip.SailorCrew					= 840;
	refShip.SpeedRate					= 13.0;
	refShip.TurnRate        			= 11.0;
	refShip.Price           			= 600000;
		if(!RTBL) // = If RTBL is NOT enabled
{
	refShip.HP              			= 20500;
		}
	else // = If RTBL IS enabled
	{
	refShip.HP				= 19500;
}
	refShip.SP              			= 550;
	refship.EmblemedSails.normalTex = "ships\sail_Dutchman.tga";
	refShip.AbordageLocation			= "Boarding Deck_01";
	refship.Type.Merchant					= false;
	refship.Type.War						= true;
	refShip.fWindAgainstSpeed				= 3.0;
	refShip.sea_enchantment					= 1.1;
	refShip.lowpolycrew = 24;
	refShip.buildtime = 120;

	refship.Rocking.y = 0.5;
	refship.Rocking.az = 0.035;
	
	refship.WaterLine							= 0.5;

	refship.SpeedDependWeight			= 0.35;
	refship.SubSeaDependWeight			= 1.0;
	refship.TurnDependWeight			= 0.4;
	refship.WindAgainstSpeed   = 3.8;//boal
	refship.CabinType          = "CabineFDM"; // boal 28.03.05
	refship.DeckType           = "Big";
	
	refship.InertiaAccelerationX	= 4.0;	refship.InertiaBrakingX		= 3.5;
	refship.InertiaAccelerationY	= 3.0;		refship.InertiaBrakingY		= 2.5;
	refship.InertiaAccelerationZ	= 4.0;	refship.InertiaBrakingZ		= 3.5;
	
	refShip.GeraldSails.rey_b2		= 1;
	refShip.GeraldSails.rey_b3		= 1;
	refShip.GeraldSails.rey_b1		= 1;
	refShip.GeraldSails.rey_b1.vscale		= 0.8;
	refShip.GeraldSails.rey_b2.vscale		= 0.65;
	refShip.GeraldSails.rey_b3.vscale		= 0.55;

	refship.Track.Enable	= true;
	refship.Track1.ZStart	= 0.25;
	refship.Track1.LifeTime = 9.5;
	refship.Track1.Width	= "7.0, 7.5";
	refship.Track1.Speed	= "8.0, 9.0";

	refship.Track2.ZStart	= -0.15;
	refship.Track2.LifeTime = 7.5;
	refship.Track2.Width	= "8.0, 10.0";
	refship.Track2.Speed	= "1.0, 2.0";

	///////////////////////////////////////////////////////////////////////////
	/// FORT
	///////////////////////////////////////////////////////////////////////////
	makeref(refShip,ShipsTypes[SHIP_FORT]);
	refShip.Name			= "Fort";
	refShip.isFort      			= true; //     rRealShip
	refShip.Class			= 1;
	refShip.Cannon          			= CANNON_TYPE_CANNON_LBS48;
	refShip.MaxCaliber			= 92;
	refShip.Weight			= Tonnes2CWT(22500);
	refShip.Capacity			= 900000;
	refShip.CannonsQuantity		= 68;
	refShip.rcannon 							= 68;
	refShip.lcannon 							= 0;
	refShip.fcannon 							= 0;
	refShip.bcannon 							= 0;
	refShip.MaxCrew         			= 1800;
	refShip.OptCrew         			= 1600;
	refShip.MinCrew         			= 400;
	refShip.BoardingCrew				= 800;
	refShip.GunnerCrew					= 800;
	refShip.CannonerCrew				= 800;
	refShip.SailorCrew					= 0;
	refShip.SpeedRate							= 0.0;
	refShip.TurnRate							= 0;
	refShip.Price									= 12000;
	refShip.HP										= 54000;
	refShip.SP										= 500;
	refShip.buildtime = 240;

	refShip.CanEncounter	= false;

	/// Check
	for (int i=0; i<SHIP_TYPES_QUANTITY_WITH_FORT-1; i++)
	{
	  	makeref(refShip, ShipsTypes[i]);
		if (!CheckAttribute(refShip,"Name")) { continue; }
		if (!CheckAttribute(refShip,"TurnRate"))
		{
			Trace("ERROR: Ship " + i + " doesn't have TurnRate attribute");
		}
		if (!CheckAttribute(refShip,"SpeedRate"))
		{
			Trace("ERROR: Ship " + i + " doesn't have SpeedRate attribute");
		}
		if (!CheckAttribute(refShip,"Class"))
		{
			Trace("ERROR: Ship " + i + " doesn't have class attribute");
		}
		else
		{
			int iClass = sti(refShip.Class);
			if (iClass > 7) { Trace("ERROR: Ship " + i + " class > 7"); }
			if (iClass < 1) { Trace("ERROR: Ship " + i + " class < 1"); }
		}
		refship.InertiaAccelerationY = stf(refship.InertiaAccelerationY) / 6.0;
		// boal 10/11/05   
		refShip.OptCrew = sti(refShip.MaxCrew);
		refShip.MaxCrew = makeint(sti(refShip.MaxCrew) * 1.25 + 0.5); // 
		///     -   ?      ,       
		refShip.cannonr  = refShip.rcannon;
		refShip.cannonl  = refShip.lcannon;
		refShip.cannonf  = refShip.fcannon;
		refShip.cannonb  = refShip.bcannon;
	}
}